package com.atlassian.applinks.internal.rest.model.migration;

import com.atlassian.applinks.internal.migration.AuthenticationConfig;
import com.atlassian.applinks.internal.rest.model.BaseRestEntity;

import javax.annotation.Nonnull;
import java.util.Objects;

public class RestAuthenticationConfig extends BaseRestEntity {
    public static final String OAUTH = "oauth";
    public static final String BASIC = "basic";
    public static final String TRUSTED = "trusted";

    public RestAuthenticationConfig(@Nonnull final AuthenticationConfig config) {
        Objects.requireNonNull(config, "authenticationConfig");
        put(OAUTH, config.isOAuthConfigured());
        put(BASIC, config.isBasicConfigured());
        put(TRUSTED, config.isTrustedConfigured());
    }
}
