(function($) {
    var contextPath =
        typeof AJS.contextPath == "function" ? AJS.contextPath() :
            typeof AJS.Confluence != "undefined" ? AJS.Confluence.getContextPath() :
                window.contextPath != null ? window.contextPath : "";

    AJS.toInit(function ($) {
        var restUrl = contextPath + "/rest/analytics/1.0/report/whitelist/search";

        var WhitelistEventList = Backbone.Collection.extend({
            url: restUrl
        });

        var WhitelistView = Backbone.View.extend({

            el: $(".whitelist-report"),

            events: {
                "keyup #whitelist-report-query" : "onQueryKeyup",
                "change #whitelist-report-whitelist" : "queryEvents",
                "submit form.whitelist-report-controls": "onControlsFormSubmit"
            },

            initialize: function() {
                this.collection = new WhitelistEventList();
                this.table = $(this.el).find('table.whitelist-report-table');
                this.queryKeyupTimer = 0;
                $(".whitelist-picker").auiSelect2();
                this.queryEvents();
            },

            render: function() {
                this.populateTable();
                return this;
            },

            populateTable: function () {
                var self = this;
                this.clearTable();
                if (this.collection) {
                    var $tableBody = this.table.find("tbody"),
                        query = this.getQuery();
                    this.collection.each(function(event) {
                        var $row = $("<tr/>")
                                .append($("<td/>").html(self.formatEventName(event.get('eventName'), query)).addClass("event-report-table-nowrap"))
                                .append($("<td/>").text(event.get('whitelistId')).addClass("event-report-table-nowrap"));
                        $tableBody.append($row);
                    });
                }
            },

            formatEventName: function(eventName, query) {
                return eventName.replace(query, "<span class='search-highlight'>" + query + "</span>");
            },

            clearTable: function() {
                this.table.find("tbody").html("");
            },

            queryEvents: function() {
                var self = this;
                this.collection.fetch({
                    data: {
                        query: self.getQuery(),
                        whitelistId: self.getWhitelistId()
                    },
                    success: function() {
                        self.render();
                    }
                });
            },

            getQuery: function() {
                return $(this.el).find("#whitelist-report-query").val();
            },

            getWhitelistId: function() {
                return $(this.el).find("#whitelist-report-whitelist").val();
            },

            onControlsFormSubmit: function(e) {
                e.preventDefault();
            },

            onQueryKeyup: function() {
                var self = this;
                // Wait until the user has finished typing before fetching the search results
                clearTimeout(this.queryKeyupTimer);
                this.queryKeyupTimer = setTimeout(function() {
                    self.queryEvents();
                }, 200);
            }
        });

        new WhitelistView();
    });
})(AJS.$);
