/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.report;

import com.atlassian.analytics.client.EventPreprocessor;
import com.atlassian.analytics.client.report.EventReportItem;
import com.atlassian.analytics.client.report.EventReporterStore;
import com.atlassian.analytics.client.report.TimeoutChecker;
import com.atlassian.analytics.event.AnalyticsEvent;
import com.atlassian.analytics.event.ProcessedEvent;
import com.atlassian.analytics.event.RawEvent;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;

public class EventReporter {
    private static final int CAPACITY = 1000;
    private static final Set<String> IGNORED_EVENTS = ImmutableSet.of((Object)"reindexissuesstarted", (Object)"reindexissuescompleted");
    private final TimeoutChecker timeoutChecker;
    private final EventPreprocessor eventPreprocessor;
    private final EventReporterStore rawStore;
    private final EventReporterStore btfProcessedStore;
    private final EventReporterStore onDemandProcessedStore;
    private boolean capturing;

    public EventReporter(TimeoutChecker timeoutChecker, EventPreprocessor eventPreprocessor) {
        this.timeoutChecker = timeoutChecker;
        this.eventPreprocessor = eventPreprocessor;
        this.rawStore = new EventReporterStore(1000, IGNORED_EVENTS);
        this.btfProcessedStore = new EventReporterStore(1000, IGNORED_EVENTS);
        this.onDemandProcessedStore = new EventReporterStore(1000, IGNORED_EVENTS);
        this.capturing = false;
    }

    public void addRawEvent(RawEvent rawEvent) {
        this.addEvent((AnalyticsEvent)rawEvent, this.rawStore, false);
        this.addProcessedEvent(rawEvent, true);
        this.addProcessedEvent(rawEvent, false);
    }

    private void addProcessedEvent(RawEvent rawEvent, boolean isOnDemand) {
        EventReporterStore processedStore;
        EventReporterStore eventReporterStore = processedStore = isOnDemand ? this.onDemandProcessedStore : this.btfProcessedStore;
        if (this.eventPreprocessor.canCollect(rawEvent, isOnDemand)) {
            ProcessedEvent processedEvent = this.eventPreprocessor.preprocess(rawEvent, isOnDemand);
            this.addProcessedEvent(processedEvent, processedStore);
        } else {
            this.addRejectedRawEvent(rawEvent, processedStore);
        }
    }

    public void addProcessedEvent(ProcessedEvent event, EventReporterStore processedStore) {
        this.addEvent((AnalyticsEvent)event, processedStore, false);
    }

    public void addRejectedRawEvent(RawEvent event, EventReporterStore processedStore) {
        this.addEvent((AnalyticsEvent)event, processedStore, true);
    }

    private void addEvent(AnalyticsEvent event, EventReporterStore store, boolean removed) {
        if (this.capturing) {
            if (this.timeoutChecker.isTimeoutExceeded()) {
                this.setCapturing(false);
            } else {
                store.add(event, removed);
            }
        }
    }

    public Collection<EventReportItem> getRawEvents() {
        this.timeoutChecker.actionHasOccurred();
        return this.rawStore.getEvents();
    }

    public Collection<EventReportItem> getOnDemandProcessedEvents() {
        this.timeoutChecker.actionHasOccurred();
        return this.onDemandProcessedStore.getEvents();
    }

    public Collection<EventReportItem> getBtfProcessedEvents() {
        this.timeoutChecker.actionHasOccurred();
        return this.btfProcessedStore.getEvents();
    }

    public void clear() {
        this.timeoutChecker.actionHasOccurred();
        this.rawStore.clear();
        this.onDemandProcessedStore.clear();
        this.btfProcessedStore.clear();
    }

    public boolean isCapturing() {
        return this.capturing;
    }

    public void setCapturing(boolean capturing) {
        this.timeoutChecker.actionHasOccurred();
        this.capturing = capturing;
    }
}

