/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.logger;

import com.atlassian.analytics.client.AnalyticsMd5Hasher;
import com.atlassian.analytics.client.ServerIdProvider;
import com.atlassian.analytics.client.cluster.ClusterInformationProvider;
import com.atlassian.analytics.client.logger.AnalyticsLogger;
import com.atlassian.analytics.client.properties.AnalyticsPropertyService;
import com.atlassian.analytics.client.sen.SenProvider;
import com.atlassian.analytics.event.AnalyticsEvent;
import com.atlassian.analytics.event.ProcessedEvent;
import com.atlassian.analytics.event.logging.LogEventFormatter;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.springframework.beans.factory.DisposableBean;
import uk.org.simonsite.log4j.appender.TimeAndSizeRollingAppender;

public class Log4jAnalyticsLogger
implements AnalyticsLogger,
DisposableBean {
    private static final Logger LOG = Logger.getLogger(Log4jAnalyticsLogger.class);
    public static final String ANALYTICS_LOGS_DIR = "analytics-logs";
    public static final String ATLASSIAN_ANALYTICS_LOG_FILENAME = ".atlassian-analytics.log";
    public static final String ANALYTICS_LOG_ROLLING_DATE_PATTERN = "'.'yyyy-MM-dd";
    private static final String ANALYTICS_LOGGER_NAME = "com.atlassian.analytics.client.btflogger";
    private static final String GZIP_COMPRESSION_ALGORITHM = "GZ";
    private static final String UTC_TIMEZONE_ID = "UTC";
    private final Logger analyticsLog;
    private final LogEventFormatter logEventFormatter;
    private final AnalyticsPropertyService applicationProperties;
    private TimeAndSizeRollingAppender analyticsRollingAppender;
    private String logPath;

    public Log4jAnalyticsLogger(LogEventFormatter logEventFormatter, AnalyticsPropertyService applicationProperties, SenProvider senProvider, ServerIdProvider serverIdProvider, ClusterInformationProvider clusterInformationProvider) {
        this.logEventFormatter = logEventFormatter;
        this.applicationProperties = applicationProperties;
        this.analyticsLog = Logger.getLogger((String)ANALYTICS_LOGGER_NAME);
        String uniqueServerId = this.generateUniqueServerId(senProvider.getSen(), serverIdProvider.getServerId(), clusterInformationProvider.getCurrentNodeId());
        this.logPath = this.generateLogPath(uniqueServerId);
        this.initAnalyticsLogger();
        this.initAnalyticsAppender();
    }

    private String generateLogPath(String uniqueServerId) {
        File logDirPath = Log4jAnalyticsLogger.getAbsoluteLogDirPath(this.applicationProperties);
        if (!logDirPath.exists() && !logDirPath.mkdir()) {
            LOG.error((Object)"Couldn't create a directory for analytics logging.");
        }
        return new File(logDirPath.getAbsolutePath(), uniqueServerId + ATLASSIAN_ANALYTICS_LOG_FILENAME).getAbsolutePath();
    }

    private String generateUniqueServerId(String sen, String serverId, String currentNodeId) {
        return AnalyticsMd5Hasher.md5Hex(StringUtils.defaultString((String)serverId) + StringUtils.defaultString((String)sen)) + (StringUtils.isNotBlank((String)currentNodeId) ? "." + currentNodeId : "");
    }

    private void initAnalyticsAppender() {
        this.analyticsRollingAppender = new TimeAndSizeRollingAppender();
        this.analyticsRollingAppender.setName(ANALYTICS_LOGGER_NAME);
        this.analyticsRollingAppender.setFile(this.logPath);
        this.analyticsRollingAppender.setDatePattern(ANALYTICS_LOG_ROLLING_DATE_PATTERN);
        this.analyticsRollingAppender.setCompressionAlgorithm(GZIP_COMPRESSION_ALGORITHM);
        this.analyticsRollingAppender.setTimeZoneId(UTC_TIMEZONE_ID);
        this.analyticsRollingAppender.setAppend(true);
        this.analyticsRollingAppender.setLayout((Layout)new PatternLayout("%m%n"));
        this.analyticsRollingAppender.setThreshold((Priority)Level.DEBUG);
        this.analyticsRollingAppender.setRollOnStartup(true);
        this.analyticsRollingAppender.activateOptions();
        this.analyticsLog.addAppender((Appender)this.analyticsRollingAppender);
    }

    private void initAnalyticsLogger() {
        this.analyticsLog.setAdditivity(false);
        this.analyticsLog.setLevel(Level.INFO);
    }

    @Override
    public void logEvent(ProcessedEvent event) {
        try {
            this.analyticsLog.info((Object)this.logEventFormatter.formatEvent((AnalyticsEvent)event));
        }
        catch (IOException e) {
            LOG.debug((Object)"Couldn't log event information to file, failed to serialize the event properties.");
        }
    }

    @Override
    public void logCleanupDeletion(String deletionMessage) {
        this.analyticsLog.debug((Object)("Deleted " + deletionMessage));
    }

    public void destroy() throws Exception {
        this.removeAppenders();
    }

    public static File getAbsoluteLogDirPath(AnalyticsPropertyService applicationProperties) {
        String homePath = applicationProperties.getHomeDirectory().getAbsolutePath();
        return new File(homePath, ANALYTICS_LOGS_DIR);
    }

    @Override
    public void reset() {
        this.removeAppenders();
        this.initAnalyticsAppender();
    }

    private void removeAppenders() {
        this.analyticsRollingAppender.close();
        this.analyticsLog.removeAllAppenders();
        this.analyticsRollingAppender = null;
    }
}

