/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.hash;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailCleaner {
    private static final Logger LOG = LoggerFactory.getLogger(EmailCleaner.class);

    public static String cleanEmail(String email) {
        if (StringUtils.isBlank((String)email)) {
            return null;
        }
        if (!email.contains("@")) {
            LOG.warn("email is invalid '{0}'. returning empty string", (Object)email);
            return null;
        }
        String[] emailParts = email.toLowerCase().split("@");
        if (emailParts.length != 2) {
            LOG.warn("email is invalid '{0}'. returning empty string", (Object)email);
            return null;
        }
        String firstPartWithoutPlus = StringUtils.substringBefore((String)emailParts[0], (String)"+");
        String firstPartWithoutDot = StringUtils.remove((String)firstPartWithoutPlus, (String)".");
        return firstPartWithoutDot + "@" + emailParts[1];
    }
}

