/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.hash;

import com.atlassian.analytics.client.hash.AnalyticsEmailHasher;
import com.atlassian.analytics.client.hash.EmailCleaner;
import com.atlassian.analytics.client.hash.reader.HashingInstructionsReader;
import com.atlassian.analytics.client.hash.reader.RemoteHashingInstructionsReader;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.mindrot.jbcrypt.BCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BcryptAnalyticsEmailHasher
implements AnalyticsEmailHasher {
    private static final Logger LOG = LoggerFactory.getLogger(BcryptAnalyticsEmailHasher.class);
    private static final String SALT_ID = "uid.onewayhash";
    private final ResettableLazyReference<HashingInstructions> processedInstructions;

    public BcryptAnalyticsEmailHasher() {
        this.processedInstructions = new HashingInstructionsResettableLazyReference(new RemoteHashingInstructionsReader());
    }

    @VisibleForTesting
    BcryptAnalyticsEmailHasher(HashingInstructionsReader reader) {
        this.processedInstructions = new HashingInstructionsResettableLazyReference(reader);
    }

    @Override
    public String hash(String email) {
        return this.hashInternal(EmailCleaner.cleanEmail(email));
    }

    @VisibleForTesting
    String hashInternal(String text) {
        if (text == null) {
            return null;
        }
        HashingInstructions hashingInstructions = (HashingInstructions)this.processedInstructions.get();
        if (StringUtils.isBlank((String)hashingInstructions.getInstructionString()) || hashingInstructions.getProcessedInstructions().isEmpty()) {
            LOG.debug("No instructions for hashing could be found. Returning null.");
            return null;
        }
        String workingResult = text;
        StringBuilder encodingsUsed = new StringBuilder();
        String previousSalt = null;
        for (String instruction : hashingInstructions.getProcessedInstructions()) {
            String fullresult;
            int saltStart = instruction.lastIndexOf("$");
            if (saltStart < 0 || saltStart == instruction.length()) {
                LOG.warn("unable to find salt for instruction '{0}'. returning empty string", (Object)instruction);
                return null;
            }
            String salt = instruction.substring(instruction.lastIndexOf("$") + 1);
            String algorithm = instruction.substring(0, instruction.lastIndexOf("$"));
            LOG.debug("hash salt '{0}'", (Object)salt);
            if (StringUtils.isBlank((String)salt) && !StringUtils.isBlank(previousSalt)) {
                LOG.info("Salt undefined for instruction '{0}'. using previous salt '{1}'", (Object)instruction, previousSalt);
                salt = previousSalt;
            } else {
                if (StringUtils.isBlank((String)salt)) {
                    LOG.warn("Salt is undefined for instruction '{0}' and there is no previous salt. returning empty string", (Object)instruction);
                    return null;
                }
                if (salt.length() != 22) {
                    LOG.warn("Salt is wrong length short '{0}'. returning empty string", (Object)salt);
                    return null;
                }
            }
            previousSalt = salt;
            if (StringUtils.isBlank((String)salt)) {
                LOG.warn("hash salt is empty for instruction '{0}'. returning empty string", (Object)instruction);
                return null;
            }
            LOG.debug("algorithm '{0}'", (Object)algorithm);
            String fixedalgorithm = algorithm.replace("b", "a");
            LOG.debug("fixedalgorithm '{0}'", (Object)fixedalgorithm);
            String tempSalt = fixedalgorithm + "$" + salt;
            LOG.debug("Encoding '{0}' with '{1}'", (Object)workingResult, (Object)tempSalt);
            try {
                fullresult = BCrypt.hashpw((String)workingResult, (String)tempSalt);
            }
            catch (Exception e) {
                LOG.warn("hash faild for instruction '{0}' and source '{1}'. returning empty string", (Object)instruction, (Object)workingResult);
                return null;
            }
            if (LOG.isDebugEnabled()) {
                encodingsUsed.append(algorithm);
                LOG.debug("Encodings so far '{0}'", (Object)encodingsUsed);
            }
            workingResult = fullresult.substring(tempSalt.length());
            LOG.debug("Got new result '{0}'", (Object)workingResult);
        }
        if (text.equals(workingResult)) {
            LOG.error("hash equals source. returning null");
            return null;
        }
        return hashingInstructions.getInstructionString() + workingResult;
    }

    @Override
    public void readRemoteInstructions() {
        this.processedInstructions.reset();
        this.processedInstructions.get();
    }

    private static class HashingInstructionsResettableLazyReference
    extends ResettableLazyReference<HashingInstructions> {
        private static final Pattern INSTRUCTION_PATTERN = Pattern.compile("\\$2[ab]{1}\\$[0-9]+\\$[^$]{0,22}");
        private final HashingInstructionsReader instructionsReader;

        public HashingInstructionsResettableLazyReference(HashingInstructionsReader instructionsReader) {
            this.instructionsReader = instructionsReader;
        }

        protected HashingInstructions create() throws Exception {
            Optional<String> remoteInstructions = this.instructionsReader.readInstructions(BcryptAnalyticsEmailHasher.SALT_ID);
            if (!remoteInstructions.isPresent()) {
                LOG.warn("No instructions for hashing could be found.");
                return new HashingInstructions((String)remoteInstructions.or((Object)""), (List<String>)ImmutableList.of());
            }
            ArrayList instructionList = Lists.newArrayList();
            Matcher matcher = INSTRUCTION_PATTERN.matcher((CharSequence)remoteInstructions.get());
            while (matcher.find()) {
                instructionList.add(matcher.group());
            }
            if (instructionList.isEmpty()) {
                LOG.warn("unable to find instructions from input '{0}'.", remoteInstructions.get());
            }
            Collections.reverse(instructionList);
            return new HashingInstructions((String)remoteInstructions.or((Object)""), (List<String>)ImmutableList.copyOf((Collection)instructionList));
        }
    }

    static final class HashingInstructions {
        private final String instructionString;
        private final List<String> processedInstructions;

        public HashingInstructions(String instructionString, List<String> processedInstructions) {
            this.instructionString = instructionString;
            this.processedInstructions = processedInstructions;
        }

        public String getInstructionString() {
            return this.instructionString;
        }

        public List<String> getProcessedInstructions() {
            return this.processedInstructions;
        }
    }
}

