/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.eventfilter.parser;

import com.atlassian.analytics.client.eventfilter.reader.FilterListReader;
import com.atlassian.analytics.client.eventfilter.whitelist.FilteredEventAttributes;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonListParser {
    private static final Logger LOG = LoggerFactory.getLogger(JsonListParser.class);
    private final FilterListReader filterListReader;

    public JsonListParser(FilterListReader filterListReader) {
        this.filterListReader = filterListReader;
    }

    public Map<String, FilteredEventAttributes> readJsonFilterList(String filterListName) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            InputStream listInputStream = this.filterListReader.readFilterList(filterListName);
            if (listInputStream != null) {
                return (Map)mapper.readValue(listInputStream, (TypeReference)new TypeReference<Map<String, FilteredEventAttributes>>(){});
            }
        }
        catch (IOException e) {
            LOG.error("Couldn't read the JSON list " + filterListName + " with error message: " + e.getMessage());
        }
        return null;
    }
}

