package com.atlassian.analytics.client.session;

import javax.annotation.Nullable;
import javax.servlet.http.HttpSession;

import com.atlassian.sal.api.web.context.HttpContext;

public class SalSessionIdProvider implements SessionIdProvider
{
    private final HttpContext httpContext;

    public SalSessionIdProvider(HttpContext httpContext)
    {
        this.httpContext = httpContext;
    }

    @Override
    @Nullable
    public String getSessionId()
    {
        HttpSession session = httpContext.getSession(false);
        if (session != null)
        {
            return session.getId();
        }
        else
        {
            return null;
        }
    }
}
