package com.atlassian.analytics.client.proxy;

import org.apache.http.HttpHost;

/**
 * Utilities for getting system proxy information.
 */
public class ProxyUtils
{
    private static final String HTTPS_PROXY_HOST_PROPERTY = "https.proxyHost";
    private static final String HTTPS_PROXY_PORT_PROPERTY = "https.proxyPort";

    public static HttpHost getProxy()
    {
        String proxyHost = getProxyHost();
        Integer proxyPort = getProxyPort();

        if (proxyHost != null && proxyPort != -1)
        {
            return new HttpHost(proxyHost, proxyPort);
        }
        return null;
    }

    public static String getProxyHost()
    {
        return System.getProperty(HTTPS_PROXY_HOST_PROPERTY);
    }

    public static int getProxyPort()
    {
        final String proxyPort = System.getProperty(HTTPS_PROXY_PORT_PROPERTY);
        return proxyPort == null ? -1 : Integer.parseInt(proxyPort);
    }
}
