package com.atlassian.analytics.client.properties;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;

import javax.annotation.Nonnull;
import java.io.File;
import java.util.Date;

public class DefaultPropertyService implements AnalyticsPropertyService {
    private final ApplicationProperties applicationProperties;

    public DefaultPropertyService(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Override
    public String getBaseUrl() {
        return applicationProperties.getBaseUrl();
    }

    @Override
    public String getBaseUrl(UrlMode urlMode) {
        return applicationProperties.getBaseUrl(urlMode);
    }

    @Override
    public String getDisplayName() {
        return applicationProperties.getDisplayName();
    }

    @Nonnull
    @Override
    public String getPlatformId() {
        return applicationProperties.getPlatformId();
    }

    @Override
    public String getVersion() {
        return applicationProperties.getVersion();
    }

    @Override
    public Date getBuildDate() {
        return applicationProperties.getBuildDate();
    }

    @Override
    public String getBuildNumber() {
        return applicationProperties.getBuildNumber();
    }

    @Override
    public File getHomeDirectory() {
        return applicationProperties.getHomeDirectory();
    }

    @Override
    public String getPropertyValue(String key) {
        return applicationProperties.getPropertyValue(key);
    }
}
