package com.atlassian.analytics.client.eventfilter.reader;

import java.io.InputStream;

/**
 * Reads a locally stored filter list.
 */
public class LocalListReader implements FilterListReader
{
    public InputStream readFilterList(String listName)
    {
        return LocalListReader.class.getResourceAsStream(getLocalListPath(listName));
    }

    private String getLocalListPath(final String listName)
    {
        return "/filters/" + listName;
    }
}
