/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.codegen.prompter.common;

import com.atlassian.maven.plugins.amps.codegen.annotations.ModuleCreatorClass;
import com.atlassian.maven.plugins.amps.codegen.prompter.AbstractModulePrompter;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.modules.common.RESTModuleCreator;
import com.atlassian.plugins.codegen.modules.common.RESTProperties;
import com.atlassian.plugins.codegen.util.ClassnameUtil;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

@ModuleCreatorClass(value=RESTModuleCreator.class)
public class RESTPrompter
extends AbstractModulePrompter<RESTProperties> {
    public RESTPrompter(Prompter prompter) {
        super(prompter);
    }

    @Override
    public RESTProperties promptForBasicProperties(PluginModuleLocation moduleLocation) throws PrompterException {
        String className = this.promptJavaClassname("Enter New Classname", "MyRestResource");
        String packageName = this.promptJavaPackagename("Enter Package Name", this.getDefaultBasePackage() + ".rest");
        String fqClass = ClassnameUtil.fullyQualifiedName((String)packageName, (String)className);
        RESTProperties props = new RESTProperties(fqClass);
        props.setPath(this.promptNotBlank("Enter REST Path", props.getPath()));
        props.setVersion(this.promptNotBlank("Enter Version", props.getVersion()));
        return props;
    }

    @Override
    public void promptForAdvancedProperties(RESTProperties props, PluginModuleLocation moduleLocation) throws PrompterException {
        props.setPackagesToScan(this.promptForList("Add Package To Scan?", "Enter Package"));
        List<String> dispatchers = this.promptForDispatchers(props.allowedDispatchers());
        if (dispatchers.size() > 0) {
            props.setDispatchers(dispatchers);
        }
    }

    private List<String> promptForDispatchers(List<String> allowedDispatchers) throws PrompterException {
        ArrayList<String> dispatchers = new ArrayList<String>();
        ArrayList<String> mutableValues = new ArrayList<String>(allowedDispatchers);
        this.promptForDispatcher(dispatchers, mutableValues);
        return dispatchers;
    }

    private void promptForDispatcher(List<String> dispatchers, List<String> allowedDispatchers) throws PrompterException {
        boolean addDispatcher = this.promptForBoolean("Add Dispatcher?", "N");
        if (addDispatcher) {
            StringBuilder dispatcherQuery = new StringBuilder("Choose A Dispatcher\n");
            ArrayList<String> indexChoices = new ArrayList<String>(allowedDispatchers.size());
            int index = 1;
            for (String dispatcher : allowedDispatchers) {
                String strIndex = Integer.toString(index);
                dispatcherQuery.append(strIndex + ": " + dispatcher + "\n");
                indexChoices.add(strIndex);
                ++index;
            }
            dispatcherQuery.append("Choose a number: ");
            String dispatcherAnswer = this.prompt(dispatcherQuery.toString(), indexChoices, "1");
            int selectedIndex = Integer.parseInt(dispatcherAnswer) - 1;
            String selectedDispatcher = allowedDispatchers.get(selectedIndex);
            dispatchers.add(selectedDispatcher);
            allowedDispatchers.remove(selectedIndex);
            this.promptForDispatcher(dispatchers, allowedDispatchers);
        }
    }
}

