/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.codegen.prompter.jira;

import com.atlassian.maven.plugins.amps.codegen.annotations.ModuleCreatorClass;
import com.atlassian.maven.plugins.amps.codegen.prompter.AbstractModulePrompter;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.modules.jira.KeyboardShortcutModuleCreator;
import com.atlassian.plugins.codegen.modules.jira.KeyboardShortcutProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

@ModuleCreatorClass(value=KeyboardShortcutModuleCreator.class)
public class KeyboardShortcutPrompter
extends AbstractModulePrompter<KeyboardShortcutProperties> {
    public KeyboardShortcutPrompter(Prompter prompter) {
        super(prompter);
    }

    @Override
    public KeyboardShortcutProperties promptForBasicProperties(PluginModuleLocation moduleLocation) throws PrompterException {
        this.suppressAdvancedNamePrompt();
        String moduleName = this.promptNotBlank("Enter Keyboard Shortcut Name", "My Keyboard Shortcut");
        KeyboardShortcutProperties props = new KeyboardShortcutProperties(moduleName);
        props.setShortcut(this.promptNotBlank("Enter Shortcut Character"));
        props.setContext(this.promptForContext());
        props.setOperationType(this.promptForOperation());
        props.setOperationValue(this.promptNotBlank("Enter Operation Value"));
        return props;
    }

    @Override
    public void promptForAdvancedProperties(KeyboardShortcutProperties props, PluginModuleLocation moduleLocation) throws PrompterException {
        props.setHidden(this.promptForBoolean("Hidden?", "N"));
        props.setOrder(this.promptForInt("Order", 10));
    }

    protected String promptForOperation() throws PrompterException {
        String operation = "";
        List operations = KeyboardShortcutProperties.ALLOWED_OPERATIONS;
        StringBuilder operationQuery = new StringBuilder("Choose An Operation\n");
        ArrayList<String> indexChoices = new ArrayList<String>(operations.size());
        HashMap<String, String> indexedValues = new HashMap<String, String>();
        int index = 1;
        for (String entry : operations) {
            String strIndex = Integer.toString(index);
            operationQuery.append(strIndex + ": " + entry + "\n");
            indexChoices.add(strIndex);
            indexedValues.put(strIndex, entry);
            ++index;
        }
        operationQuery.append("Choose a number: ");
        String operationAnswer = this.prompt(operationQuery.toString(), indexChoices, "");
        operation = (String)indexedValues.get(operationAnswer);
        return operation;
    }

    protected String promptForContext() throws PrompterException {
        String context = "";
        List contexts = KeyboardShortcutProperties.ALLOWED_CONTEXTS;
        StringBuilder contextQuery = new StringBuilder("Choose A Context\n");
        ArrayList<String> indexChoices = new ArrayList<String>(contexts.size());
        HashMap<String, String> indexedValues = new HashMap<String, String>();
        int index = 1;
        for (String entry : contexts) {
            String strIndex = Integer.toString(index);
            contextQuery.append(strIndex + ": " + entry + "\n");
            indexChoices.add(strIndex);
            indexedValues.put(strIndex, entry);
            ++index;
        }
        contextQuery.append("Choose a number: ");
        String contextAnswer = this.prompt(contextQuery.toString(), indexChoices, "");
        context = (String)indexedValues.get(contextAnswer);
        return context;
    }
}

