/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.codegen.annotations.asm;

import com.atlassian.plugins.codegen.annotations.asm.AbstractAnnotationParser;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class CustomFieldSearcherLocator
extends AbstractAnnotationParser {
    public static final String JIRA_SEARCHERS_PACKAGE = "com.atlassian.jira.issue.customfields.searchers";
    private Log log;
    private Map<String, String> searcherRegistry;

    public CustomFieldSearcherLocator(Map<String, String> searcherRegistry) {
        this.searcherRegistry = searcherRegistry;
    }

    public void parse() throws Exception {
        this.parse(JIRA_SEARCHERS_PACKAGE, (ClassVisitor)new FieldClassVisitor());
    }

    public void parse(String basePackage) throws Exception {
        this.parse(basePackage, (ClassVisitor)new FieldClassVisitor());
    }

    public class FieldClassVisitor
    extends EmptyVisitor {
        private String visitedClassname;
        private boolean isCustomFieldSearcher;

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.visitedClassname = CustomFieldSearcherLocator.normalize((String)name);
            String iface = "com/atlassian/jira/issue/customfields/CustomFieldSearcher";
            this.isCustomFieldSearcher = false;
            this.isCustomFieldSearcher = ArrayUtils.contains((Object[])interfaces, (Object)iface);
            if (!this.isCustomFieldSearcher) {
                this.isCustomFieldSearcher = this.superHasInterface(superName, iface);
            }
            if (this.isCustomFieldSearcher) {
                String simpleName = StringUtils.substringAfterLast((String)this.visitedClassname, (String)".");
                CustomFieldSearcherLocator.this.searcherRegistry.put(simpleName, this.visitedClassname);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private boolean superHasInterface(String superName, String interfaceName) {
            InputStream is;
            boolean hasInterface;
            block5: {
                hasInterface = false;
                if (CustomFieldSearcherLocator.normalize((String)superName).equals("java.lang.Object")) {
                    return hasInterface;
                }
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                String path = superName.replace('.', '/');
                is = null;
                try {
                    is = classLoader.getResourceAsStream(path + ".class");
                    if (null == is) break block5;
                    ClassReader classReader = new ClassReader(is);
                    String[] interfaces = classReader.getInterfaces();
                    hasInterface = ArrayUtils.contains((Object[])classReader.getInterfaces(), (Object)interfaceName);
                    if (hasInterface) break block5;
                    hasInterface = this.superHasInterface(classReader.getSuperName(), interfaceName);
                }
                catch (Exception e) {
                    IOUtils.closeQuietly(is);
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            return hasInterface;
        }

        public AnnotationVisitor visitAnnotation(String annotationName, boolean isVisible) {
            return null;
        }

        public MethodVisitor visitMethod(int i, String s, String s1, String s2, String[] strings) {
            return null;
        }

        public FieldVisitor visitField(int i, String s, String s1, String s2, Object o) {
            return null;
        }
    }
}

