/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules.common;

import com.atlassian.plugins.codegen.modules.BasicClassModuleProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RESTProperties
extends BasicClassModuleProperties {
    public static final String PATH = "PATH";
    public static final String VERSION = "VERSION";
    public static final String PACKAGES_TO_SCAN = "PACKAGES_TO_SCAN";
    public static final String DISPATCHERS = "DISPATCHERS";
    private static final List<String> ALLOWED_DISPATCHERS = RESTProperties.initDispatchers();

    private static List<String> initDispatchers() {
        ArrayList<String> dispatchers = new ArrayList<String>(4);
        dispatchers.add("REQUEST");
        dispatchers.add("INCLUDE");
        dispatchers.add("FORWARD");
        dispatchers.add("ERROR");
        return Collections.unmodifiableList(dispatchers);
    }

    public RESTProperties() {
        this("MyRESTResource");
    }

    public RESTProperties(String fqClassname) {
        super(fqClassname);
        this.put(DISPATCHERS, new ArrayList());
        this.put(PACKAGES_TO_SCAN, new ArrayList());
        this.setPath("/" + this.getProperty("CLASSNAME").toLowerCase());
        this.setVersion("1.0");
    }

    public void setPath(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        this.setProperty(PATH, path);
    }

    public String getPath() {
        return this.getProperty(PATH);
    }

    public void setVersion(String version) {
        this.setProperty(VERSION, version);
    }

    public String getVersion() {
        return this.getProperty(VERSION);
    }

    public void setDispatchers(List<String> dispatchers) {
        this.put(DISPATCHERS, dispatchers);
    }

    public void addDispatcher(String dispatcher) {
        ArrayList<String> dispatchers = (ArrayList<String>)this.get(DISPATCHERS);
        if (dispatchers == null) {
            dispatchers = new ArrayList<String>();
            this.setDispatchers(dispatchers);
        }
        dispatchers.add(dispatcher);
    }

    public void setPackagesToScan(List<String> packages) {
        this.put(PACKAGES_TO_SCAN, packages);
    }

    public void addPackageToScan(String packageToScan) {
        ArrayList<String> packages = (ArrayList<String>)this.get(PACKAGES_TO_SCAN);
        if (packages == null) {
            packages = new ArrayList<String>();
            this.setPackagesToScan(packages);
        }
        packages.add(packageToScan);
    }

    public List<String> getPackagesToScan() {
        return (List)this.get(PACKAGES_TO_SCAN);
    }

    public List<String> getDispatchers() {
        return (List)this.get(DISPATCHERS);
    }

    public List<String> allowedDispatchers() {
        return ALLOWED_DISPATCHERS;
    }
}

