/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules.jira;

import com.atlassian.plugins.codegen.annotations.Dependencies;
import com.atlassian.plugins.codegen.annotations.Dependency;
import com.atlassian.plugins.codegen.annotations.JiraPluginModuleCreator;
import com.atlassian.plugins.codegen.modules.AbstractPluginModuleCreator;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.modules.jira.ActionProperties;
import com.atlassian.plugins.codegen.modules.jira.View;
import com.atlassian.plugins.codegen.modules.jira.WebworkProperties;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

@JiraPluginModuleCreator
@Dependencies(value={@Dependency(groupId="org.mockito", artifactId="mockito-all", version="1.8.5", scope="test"), @Dependency(groupId="org.apache.httpcomponents", artifactId="httpclient", version="4.1.1", scope="test")})
public class WebworkModuleCreator
extends AbstractPluginModuleCreator<WebworkProperties> {
    public static final String MODULE_NAME = "Webwork Plugin";
    private static final String TEMPLATE_PREFIX = "templates/jira/webwork/";
    private static final String CLASS_TEMPLATE = "templates/jira/webwork/WebworkAction.java.vtl";
    private static final String UNIT_TEST_TEMPLATE = "templates/generic/GenericTest.java.vtl";
    private static final String FUNC_TEST_TEMPLATE = "templates/jira/webwork/WebworkActionFuncTest.java.vtl";
    private static final String VIEW_TEMPLATE = "templates/common/actionview.vm.vtl";
    private static final String EXAMPLE_CLASS_TEMPLATE = "templates/jira/webwork/Exampletemplates/jira/webwork/WebworkAction.java.vtl";
    private static final String PLUGIN_MODULE_TEMPLATE = "templates/jira/webwork/webwork-plugin.xml.vtl";

    @Override
    public void createModule(PluginModuleLocation location, WebworkProperties props) throws Exception {
        if (!props.includeExamples()) {
            for (ActionProperties action : props.getActions()) {
                this.templateHelper.writeJavaClassFromTemplate(CLASS_TEMPLATE, action.getClassname(), location.getSourceDirectory(), action.getPackage(), action);
                this.templateHelper.writeJavaClassFromTemplate(UNIT_TEST_TEMPLATE, this.testClassname(action.getClassname()), location.getTestDirectory(), action.getPackage(), action);
                for (View view : action.getViews()) {
                    String viewPath = FilenameUtils.separatorsToSystem((String)view.getPath());
                    if (viewPath.startsWith("templates" + File.separator) || viewPath.startsWith(File.separator + "templates" + File.separator)) {
                        viewPath = StringUtils.substringAfter((String)viewPath, (String)("templates" + File.separator));
                    }
                    File viewFolder = new File(location.getTemplateDirectory(), FilenameUtils.getPath((String)viewPath));
                    String viewFile = FilenameUtils.getName((String)viewPath);
                    action.setProperty("CURRENT_VIEW", viewFile);
                    this.templateHelper.writeFileFromTemplate(VIEW_TEMPLATE, FilenameUtils.getName((String)viewPath), viewFolder, action);
                }
            }
        }
        this.addModuleToPluginXml(PLUGIN_MODULE_TEMPLATE, location, props);
    }

    public String getModuleName() {
        return MODULE_NAME;
    }
}

