/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules;

import com.atlassian.plugins.codegen.modules.AbstractNameBasedModuleProperties;
import com.atlassian.plugins.codegen.modules.ClassBasedModuleProperties;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractClassBasedModuleProperties
extends AbstractNameBasedModuleProperties
implements ClassBasedModuleProperties {
    protected AbstractClassBasedModuleProperties() {
    }

    public void setFullyQualifiedClassname(String fqName) {
        if (StringUtils.isNotBlank((String)fqName)) {
            if (fqName.lastIndexOf(".") > 0) {
                String classname = StringUtils.substringAfterLast((String)fqName, (String)".");
                String packageName = StringUtils.substringBeforeLast((String)fqName, (String)".");
                this.setProperty("CLASSNAME", classname);
                this.setClassUnderTest(fqName);
                this.setProperty("PACKAGE", packageName);
            } else {
                String classname = fqName;
                this.setProperty("CLASSNAME", classname);
                this.setClassUnderTest(fqName);
                this.setProperty("PACKAGE", "");
            }
            this.setProperty("FQ_CLASSNAME", fqName);
        }
    }

    public void setClassUnderTest(String fqName) {
        if (StringUtils.isNotBlank((String)fqName)) {
            if (fqName.lastIndexOf(".") > 0) {
                String classname = StringUtils.substringAfterLast((String)fqName, (String)".");
                String packageName = StringUtils.substringBeforeLast((String)fqName, (String)".");
                this.setProperty("CLASS_UNDER_TEST", classname);
                this.setProperty("PACKAGE_UNDER_TEST", packageName);
            } else {
                String classname = fqName;
                this.setProperty("CLASS_UNDER_TEST", classname);
                this.setProperty("PACKAGE_UNDER_TEST", "");
            }
            this.setProperty("FQ_CLASS_UNDER_TEST", fqName);
        }
    }

    public String getFullyQualifiedClassname() {
        return this.getProperty("FQ_CLASSNAME");
    }

    public String getClassname() {
        return this.getProperty("CLASSNAME");
    }

    public String getPackage() {
        return this.getProperty("PACKAGE");
    }

    public String getClassUnderTest() {
        return this.getProperty("CLASS_UNDER_TEST");
    }

    public String getFullyQualifiedClassUnderTest() {
        return this.getProperty("FQ_CLASS_UNDER_TEST");
    }

    public String getPackageUnderTest() {
        return this.getProperty("PACKAGE_UNDER_TEST");
    }
}

