/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules.jira;

import com.atlassian.plugins.codegen.PluginProjectChange;
import com.atlassian.plugins.codegen.PluginProjectChangeset;
import com.atlassian.plugins.codegen.annotations.JiraPluginModuleCreator;
import com.atlassian.plugins.codegen.modules.AbstractPluginModuleCreator;
import com.atlassian.plugins.codegen.modules.Dependencies;
import com.atlassian.plugins.codegen.modules.jira.ActionProperties;
import com.atlassian.plugins.codegen.modules.jira.View;
import com.atlassian.plugins.codegen.modules.jira.WebworkProperties;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

@JiraPluginModuleCreator
public class WebworkModuleCreator
extends AbstractPluginModuleCreator<WebworkProperties> {
    public static final String MODULE_NAME = "Webwork Plugin";
    private static final String TEMPLATE_PREFIX = "templates/jira/webwork/";
    private static final String CLASS_TEMPLATE = "templates/jira/webwork/WebworkAction.java.vtl";
    private static final String UNIT_TEST_TEMPLATE = "templates/generic/GenericTest.java.vtl";
    private static final String VIEW_TEMPLATE = "templates/common/actionview.vm.vtl";
    private static final String EXAMPLE_CLASS_TEMPLATE = "templates/jira/webwork/Exampletemplates/jira/webwork/WebworkAction.java.vtl";
    private static final String PLUGIN_MODULE_TEMPLATE = "templates/jira/webwork/webwork-plugin.xml.vtl";

    @Override
    public PluginProjectChangeset createModule(WebworkProperties props) throws Exception {
        PluginProjectChangeset ret = new PluginProjectChangeset().with(new PluginProjectChange[]{Dependencies.HTTPCLIENT_TEST, Dependencies.MOCKITO_TEST}).with(this.createModule(props, PLUGIN_MODULE_TEMPLATE));
        if (!props.includeExamples()) {
            for (ActionProperties action : props.getActions()) {
                ret = ret.with(this.createClassAndTests(action, CLASS_TEMPLATE, UNIT_TEST_TEMPLATE));
                for (View view : action.getViews()) {
                    ret = ret.with(this.createViewResource(action, view, VIEW_TEMPLATE));
                }
            }
        }
        return ret;
    }

    protected PluginProjectChangeset createViewResource(Map<Object, Object> props, View view, String templateName) throws Exception {
        String resourceFullPath = FilenameUtils.separatorsToSystem((String)view.getPath());
        String path = FilenameUtils.getPath((String)resourceFullPath);
        String fileName = FilenameUtils.getName((String)resourceFullPath);
        ImmutableMap tempProps = ImmutableMap.builder().putAll(props).put((Object)"CURRENT_VIEW", (Object)fileName).build();
        return this.createTemplateResource((Map<Object, Object>)tempProps, path, fileName, templateName);
    }

    public String getModuleName() {
        return MODULE_NAME;
    }
}

