/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules.jira;

import com.atlassian.plugins.codegen.modules.BasicNameModuleProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class KeyboardShortcutProperties
extends BasicNameModuleProperties {
    public static final String HIDDEN = "HIDDEN";
    public static final String ORDER = "ORDER";
    public static final String SHORTCUT = "SHORTCUT";
    public static final String OPERATION_TYPE = "OPERATION_TYPE";
    public static final String OPERATION_VALUE = "OPERATION_VALUE";
    public static final String CONTEXT = "CONTEXT";
    public static final List<String> ALLOWED_CONTEXTS = KeyboardShortcutProperties.initContexts();
    public static final List<String> ALLOWED_OPERATIONS = KeyboardShortcutProperties.initOperations();

    private static List<String> initContexts() {
        ArrayList<String> contexts = new ArrayList<String>(3);
        contexts.add("global");
        contexts.add("issueaction");
        contexts.add("issuenavigation");
        return Collections.unmodifiableList(contexts);
    }

    private static List<String> initOperations() {
        ArrayList<String> operations = new ArrayList<String>();
        operations.add("click");
        operations.add("evaluate");
        operations.add("execute");
        operations.add("followLink");
        operations.add("goTo");
        operations.add("moveToAndClick");
        operations.add("moveToAndFocus");
        operations.add("moveToNextItem");
        operations.add("moveToPrevItem");
        return Collections.unmodifiableList(operations);
    }

    public KeyboardShortcutProperties() {
        this("My Keyboard Shortcut");
    }

    public KeyboardShortcutProperties(String moduleName) {
        super(moduleName);
        this.setHidden(false);
        this.setOrder(10);
        this.setContext("global");
    }

    public void setHidden(boolean hidden) {
        this.setProperty(HIDDEN, Boolean.toString(hidden));
    }

    public boolean isHidden() {
        return Boolean.valueOf(this.getProperty(HIDDEN));
    }

    public void setOrder(int order) {
        this.setProperty(ORDER, Integer.toString(order));
    }

    public String getOrder() {
        return this.getProperty(ORDER);
    }

    public int getOrderAsInt() {
        return Integer.parseInt(this.getProperty(ORDER));
    }

    public void setShortcut(String s) {
        this.setProperty(SHORTCUT, s);
    }

    public String getShortcut() {
        return this.getProperty(SHORTCUT);
    }

    public void setContext(String s) {
        this.setProperty(CONTEXT, s);
    }

    public String getContext() {
        return this.getProperty(CONTEXT);
    }

    public void setOperationType(String s) {
        this.setProperty(OPERATION_TYPE, s);
    }

    public String getOperationType() {
        return this.getProperty(OPERATION_TYPE);
    }

    public void setOperationValue(String s) {
        this.setProperty(OPERATION_VALUE, s);
    }

    public String getOperationValue() {
        return this.getProperty(OPERATION_VALUE);
    }
}

