/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen;

import io.atlassian.fugue.Option;
import java.util.Objects;

public final class ArtifactId {
    private final Option<String> groupId;
    private final String artifactIdStr;

    public static ArtifactId artifactId(String artifactId) {
        return new ArtifactId((Option<String>)Option.none(String.class), artifactId);
    }

    public static ArtifactId artifactId(String groupId, String artifactId) {
        return new ArtifactId((Option<String>)Option.some((Object)groupId), artifactId);
    }

    public static ArtifactId artifactId(Option<String> groupId, String artifactId) {
        return new ArtifactId(groupId, artifactId);
    }

    private ArtifactId(Option<String> groupId, String artifactId) {
        this.groupId = Objects.requireNonNull(groupId, "groupId");
        this.artifactIdStr = Objects.requireNonNull(artifactId, "artifactId");
    }

    public Option<String> getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactIdStr;
    }

    public String getCombinedId() {
        String prefix = (String)this.groupId.map(g -> g + ":").getOrElse((Object)"");
        return prefix + this.artifactIdStr;
    }

    public String toString() {
        return this.getCombinedId();
    }

    public boolean equals(Object other) {
        if (other instanceof ArtifactId) {
            ArtifactId c = (ArtifactId)other;
            return this.groupId.equals(c.groupId) && this.artifactIdStr.equals(c.artifactIdStr);
        }
        return false;
    }

    public int hashCode() {
        return this.getCombinedId().hashCode();
    }
}

