/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen;

import com.atlassian.plugins.codegen.PluginProjectChange;
import com.atlassian.plugins.codegen.SummarizeAsGroup;
import java.util.Objects;
import java.util.Optional;

public final class BundleInstruction
implements PluginProjectChange,
SummarizeAsGroup {
    private Category category;
    private String packageName;
    private Optional<String> version;

    public static BundleInstruction importPackage(String packageName, String version) {
        return new BundleInstruction(Category.IMPORT, packageName, Optional.of(version));
    }

    public static BundleInstruction dynamicImportPackage(String packageName, String version) {
        return new BundleInstruction(Category.DYNAMIC_IMPORT, packageName, Optional.of(version));
    }

    public static BundleInstruction privatePackage(String packageName) {
        return new BundleInstruction(Category.PRIVATE, packageName, Optional.empty());
    }

    public BundleInstruction(Category category, String packageName, Optional<String> version) {
        this.category = Objects.requireNonNull(category, "category");
        this.packageName = Objects.requireNonNull(packageName, "packageName");
        this.version = Objects.requireNonNull(version, "version");
    }

    public Category getCategory() {
        return this.category;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Optional<String> getVersion() {
        return this.version;
    }

    @Override
    public String getGroupName() {
        return "bundle instructions";
    }

    public String toString() {
        return "[bundle instruction: " + this.category.getElementName() + " " + this.packageName + "]";
    }

    public static enum Category {
        IMPORT("Import-Package"),
        PRIVATE("Private-Package"),
        DYNAMIC_IMPORT("DynamicImport-Package");

        private String elementName;

        private Category(String elementName) {
            this.elementName = elementName;
        }

        public String getElementName() {
            return this.elementName;
        }
    }
}

