/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.administration.quicksearch.util;

import com.atlassian.sal.api.ApplicationProperties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionVerifier {
    private final String versionString;
    private final Integer majorVersion;
    private final Integer minorVersion;

    public VersionVerifier(ApplicationProperties applicationProperties) {
        this.versionString = applicationProperties.getVersion();
        String versionRegex = "^(\\d+)\\.(\\d+)";
        Pattern versionPattern = Pattern.compile(versionRegex);
        Matcher versionMatcher = versionPattern.matcher(this.versionString);
        if (!versionMatcher.find()) {
            this.majorVersion = -1;
            this.minorVersion = -1;
        } else {
            this.majorVersion = Integer.decode(versionMatcher.group(1));
            this.minorVersion = Integer.decode(versionMatcher.group(2));
        }
    }

    public boolean hasVersion() {
        return this.majorVersion >= 0;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public boolean isGreaterThan(int minMajorVersion, int minMinorVersion) {
        this.checkVersion();
        return this.majorVersion > minMajorVersion || this.majorVersion.equals(minMajorVersion) && this.minorVersion > minMinorVersion;
    }

    public boolean isGreaterThanOrEqualTo(int minMajorVersion, int minMinorVersion) {
        this.checkVersion();
        return this.majorVersion > minMajorVersion || this.majorVersion.equals(minMajorVersion) && this.minorVersion >= minMinorVersion;
    }

    public boolean isLessThan(int maxMajorVersion, int maxMinorVersion) {
        this.checkVersion();
        return this.majorVersion < maxMajorVersion || this.majorVersion.equals(maxMajorVersion) && this.minorVersion < maxMinorVersion;
    }

    public boolean isLessThanOrEqualTo(int maxMajorVersion, int maxMinorVersion) {
        this.checkVersion();
        return this.majorVersion < maxMajorVersion || this.majorVersion.equals(maxMajorVersion) && this.minorVersion <= maxMinorVersion;
    }

    private void checkVersion() {
        if (!this.hasVersion()) {
            throw new IllegalStateException("Could not parse version '" + this.versionString + "'");
        }
    }
}

