/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.administration.quicksearch.rest;

import com.atlassian.administration.quicksearch.rest.LinkBean;
import com.atlassian.administration.quicksearch.rest.LocationBean;
import com.atlassian.administration.quicksearch.rest.SectionBean;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public final class LocationBeanUtils {
    private LocationBeanUtils() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static LocationBean newEmptyBean() {
        return new LocationBean(null, Collections.<LinkBean>emptyList(), Collections.<SectionBean>emptyList());
    }

    public static LocationBean merge(LocationBean first, LocationBean ... rest) {
        return LocationBeanUtils.merge((Iterable<LocationBean>)ImmutableList.builder().add((Object)first).addAll(Arrays.asList(rest)).build());
    }

    public static LocationBean merge(Iterable<LocationBean> locationBeans) {
        if (Iterables.isEmpty(locationBeans)) {
            return LocationBeanUtils.newEmptyBean();
        }
        if (Iterables.size(locationBeans) == 1) {
            return (LocationBean)Iterables.get(locationBeans, (int)0);
        }
        ArrayList sections = Lists.newArrayList();
        ArrayList links = Lists.newArrayList();
        for (LocationBean bean : locationBeans) {
            sections.addAll(bean.sections());
            links.addAll(bean.links());
        }
        return new LocationBean(null, links, sections);
    }

    public static LocationBean deserialize(String json) {
        return (LocationBean)new Gson().fromJson(json, LocationBean.class);
    }
}

