/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.LocalIdOptional;
import com.atlassian.adf.model.ex.node.ListException;
import com.atlassian.adf.model.node.AbstractListNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.ListItem;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.Functions;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@Documentation(state=Documentation.State.WRONG, date="2023-07-26", comment="the 'order' may be 0, now")
public class OrderedList
extends AbstractListNode<OrderedList> {
    static final Factory<OrderedList> FACTORY = new Factory<OrderedList>("orderedList", OrderedList.class, OrderedList::parse);
    @Nullable
    private Integer order;

    private OrderedList() {
    }

    public static OrderedList ol() {
        return new OrderedList();
    }

    public static OrderedList ol(ListItem ... content) {
        return (OrderedList)OrderedList.ol().content(content);
    }

    public static OrderedList ol(Iterable<? extends ListItem> content) {
        return (OrderedList)OrderedList.ol().content(content);
    }

    public static OrderedList ol(Stream<? extends ListItem> content) {
        return (OrderedList)OrderedList.ol().content(content);
    }

    public static OrderedList ol(int order) {
        return OrderedList.ol().order(order);
    }

    public static OrderedList ol(int order, ListItem ... content) {
        return (OrderedList)OrderedList.ol().order(order).content(content);
    }

    public static OrderedList ol(int order, Iterable<? extends ListItem> content) {
        return (OrderedList)OrderedList.ol().order(order).content(content);
    }

    public static OrderedList ol(int order, Stream<? extends ListItem> content) {
        return (OrderedList)OrderedList.ol().order(order).content(content);
    }

    public static OrderedList orderedList() {
        return new OrderedList();
    }

    public static OrderedList orderedList(ListItem ... content) {
        return (OrderedList)OrderedList.orderedList().content(content);
    }

    public static OrderedList orderedList(Iterable<? extends ListItem> content) {
        return (OrderedList)OrderedList.orderedList().content(content);
    }

    public static OrderedList orderedList(Stream<? extends ListItem> content) {
        return (OrderedList)OrderedList.orderedList().content(content);
    }

    public static OrderedList orderedList(int order) {
        return OrderedList.orderedList().order(order);
    }

    public static OrderedList orderedList(int order, ListItem ... content) {
        return (OrderedList)OrderedList.orderedList().order(order).content(content);
    }

    public static OrderedList orderedList(int order, Iterable<? extends ListItem> content) {
        return (OrderedList)OrderedList.orderedList().order(order).content(content);
    }

    public static OrderedList orderedList(int order, Stream<? extends ListItem> content) {
        return (OrderedList)OrderedList.ol().order(order).content(content);
    }

    public Optional<Integer> order() {
        return Optional.ofNullable(this.order);
    }

    public OrderedList order(@Nullable Integer order) {
        if (order != null && order < 0) {
            throw new ListException.OrderMustNotBeNegative(order);
        }
        this.order = order;
        return this;
    }

    @Override
    public OrderedList copy() {
        return OrderedList.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "orderedList";
    }

    @Override
    public Map<String, ?> toMap() {
        this.requireNotEmpty();
        return this.mapWithType().addIf(this.order != null || this.localId != null, "attrs", () -> FieldMap.map().addIfPresent("order", this.order).addIfPresent("localId", this.localId)).let(this::addContent);
    }

    private static OrderedList parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "orderedList");
        OrderedList ol = (OrderedList)OrderedList.ol().parseRequiredContent(map, ListItem.class);
        ParserSupport.getAttrInt(map, "order").filter(x -> x >= 0).ifPresent(ol::order);
        LocalIdOptional.parseLocalId(ol, map);
        return ol;
    }

    @Override
    protected boolean contentNodeEquals(OrderedList other) {
        return super.contentNodeEquals(other) && Objects.equals(this.order, other.order);
    }

    @Override
    protected int contentNodeHashCode() {
        return super.contentNodeHashCode() * 31 + Objects.hashCode(this.order);
    }

    @Override
    protected void appendContentNodeFields(AbstractNode.ToStringHelper buf) {
        super.appendContentNodeFields(buf);
        buf.appendField("order", this.order);
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        if (this.content.isEmpty()) {
            return;
        }
        int[] index = new int[]{this.order().orElse(1)};
        sb.append(index[0]).append(". ");
        Functions.iterateJoined(this.content, child -> child.appendPlainText(sb), () -> {
            index[0] = index[0] + 1;
            sb.append('\n').append(index[0]).append(". ");
        });
    }
}

