/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.LocalIdOptional;
import com.atlassian.adf.model.ex.node.ListException;
import com.atlassian.adf.model.ex.node.TaskListException;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.CodeBlock;
import com.atlassian.adf.model.node.Paragraph;
import com.atlassian.adf.model.node.TaskList;
import com.atlassian.adf.model.node.type.ListItemContent;
import com.atlassian.adf.model.node.type.ListNode;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@Documentation(state=Documentation.State.INCOMPLETE, date="2023-07-26", comment="should say 'bulletList' and 'orderedList' are disallowed for the first content item")
public class ListItem
extends AbstractContentNode<ListItem, ListItemContent>
implements LocalIdOptional<ListItem> {
    static final Factory<ListItem> FACTORY = new Factory<ListItem>("listItem", ListItem.class, ListItem::parse);
    @Nullable
    private String localId;

    private ListItem() {
    }

    public static ListItem li() {
        return new ListItem();
    }

    public static ListItem li(String content) {
        return ListItem.li((ListItemContent)Paragraph.p(content));
    }

    public static ListItem li(String ... content) {
        return ListItem.li((ListItemContent)Paragraph.p(content));
    }

    public static ListItem li(ListItemContent content) {
        return (ListItem)ListItem.li().content(content);
    }

    public static ListItem li(ListItemContent ... content) {
        return (ListItem)ListItem.li().content(content);
    }

    public static ListItem li(Iterable<? extends ListItemContent> content) {
        return (ListItem)ListItem.li().content(content);
    }

    public static ListItem li(Stream<? extends ListItemContent> content) {
        return (ListItem)ListItem.li().content(content);
    }

    public static ListItem listItem() {
        return new ListItem();
    }

    public static ListItem listItem(String content) {
        return ListItem.li((ListItemContent)Paragraph.p(content));
    }

    public static ListItem listItem(String ... content) {
        return ListItem.li((ListItemContent)Paragraph.p(content));
    }

    public static ListItem listItem(ListItemContent content) {
        return (ListItem)ListItem.li().content(content);
    }

    public static ListItem listItem(ListItemContent ... content) {
        return (ListItem)ListItem.li().content(content);
    }

    public static ListItem listItem(Iterable<? extends ListItemContent> content) {
        return (ListItem)ListItem.li().content(content);
    }

    public static ListItem listItem(Stream<? extends ListItemContent> content) {
        return (ListItem)ListItem.li().content(content);
    }

    @Override
    public ListItem localId(@Nullable String localId) {
        this.localId = localId;
        return this;
    }

    @Override
    public Optional<String> localId() {
        return Optional.ofNullable(this.localId);
    }

    @Override
    public Class<ListItemContent> contentClass() {
        return ListItemContent.class;
    }

    @Override
    public ListItem copy() {
        return ListItem.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "listItem";
    }

    @Override
    protected int contentNodeHashCode() {
        return Objects.hashCode(this.localId);
    }

    @Override
    protected boolean contentNodeEquals(ListItem other) {
        return Objects.equals(this.localId, other.localId);
    }

    @Override
    protected void appendContentNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("localId", this.localId);
    }

    @Override
    protected void contentNodeValidate() {
        this.validateFirstContentItemIsNotAList();
    }

    private void validateFirstContentItemIsNotAList() {
        this.requireNotEmpty();
        ListItemContent firstContentItem = (ListItemContent)this.content.get(0);
        if (firstContentItem instanceof ListNode) {
            throw new ListException.CannotUseNestedListAsFirstContentItem();
        }
        if (firstContentItem instanceof TaskList) {
            throw new TaskListException.CannotUseNestedTaskListAsFirstContentItem();
        }
    }

    @Override
    public Map<String, ?> toMap() {
        this.validateFirstContentItemIsNotAList();
        return this.mapWithType().addIf(this.localId != null, "attrs", () -> FieldMap.map("localId", this.localId)).let(this::addContent);
    }

    @Override
    protected void validateContentNodeForAppend(ListItemContent node) {
        super.validateContentNodeForAppend(node);
        if (node instanceof Paragraph) {
            ((Paragraph)node).disableMarks(this);
        } else if (node instanceof CodeBlock) {
            ((CodeBlock)node).disableMarks(this);
        } else if (node instanceof ListNode) {
            if (this.content.isEmpty()) {
                throw new ListException.CannotUseNestedListAsFirstContentItem();
            }
        } else if (node instanceof TaskList && this.content.isEmpty()) {
            throw new TaskListException.CannotUseNestedTaskListAsFirstContentItem();
        }
    }

    private static ListItem parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "listItem");
        ListItem li = (ListItem)ListItem.li().parseRequiredContent(map, ListItemContent.class);
        LocalIdOptional.parseLocalId(li, map);
        return li;
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        this.appendPlainTextContentJoinedWith('\n', sb);
    }
}

