/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.LocalIdOptional;
import com.atlassian.adf.model.ex.node.LayoutColumnException;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.CodeBlock;
import com.atlassian.adf.model.node.Expand;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@Documentation(state=Documentation.State.UNDOCUMENTED, date="2023-07-26")
public class LayoutColumn
extends AbstractContentNode<LayoutColumn, LayoutColumnContent>
implements LocalIdOptional<LayoutColumn> {
    static final Factory<LayoutColumn> FACTORY = new Factory<LayoutColumn>("layoutColumn", LayoutColumn.class, LayoutColumn::parse);
    private Number width;
    @Nullable
    private String localId;

    private LayoutColumn(Number width) {
        this.width = LayoutColumn.validateWidth(width);
    }

    public static LayoutColumn layoutColumn(Number width) {
        return new LayoutColumn(width);
    }

    public LayoutColumn width(Number width) {
        this.width = LayoutColumn.validateWidth(width);
        return this;
    }

    public Number width() {
        return this.width;
    }

    @Override
    public LayoutColumn localId(@Nullable String localId) {
        this.localId = localId;
        return this;
    }

    @Override
    public Optional<String> localId() {
        return Optional.ofNullable(this.localId);
    }

    @Override
    protected int contentNodeHashCode() {
        return Objects.hash(this.width, this.localId);
    }

    @Override
    protected boolean contentNodeEquals(LayoutColumn other) {
        return Objects.equals(this.width, other.width) && Objects.equals(this.localId, other.localId);
    }

    @Override
    protected void appendContentNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("width", this.width);
        buf.appendField("localId", this.localId);
    }

    @Override
    public Class<LayoutColumnContent> contentClass() {
        return LayoutColumnContent.class;
    }

    @Override
    public LayoutColumn copy() {
        return LayoutColumn.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "layoutColumn";
    }

    @Override
    protected void contentNodeValidate() {
        this.requireNotEmpty();
    }

    @Override
    protected void validateContentNodeForAppend(LayoutColumnContent node) {
        super.validateContentNodeForAppend(node);
        if (node instanceof CodeBlock) {
            ((CodeBlock)node).disableMarks(this);
        } else if (node instanceof Expand) {
            ((Expand)node).disableMarks(this);
        }
    }

    @Override
    public Map<String, ?> toMap() {
        this.requireNotEmpty();
        return this.mapWithType().add("attrs", FieldMap.map().addIfPresent("localId", this.localId).add("width", this.width)).let(this::addContent);
    }

    private static LayoutColumn parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "layoutColumn");
        Number width = ParserSupport.getAttrNumberOrThrow(map, "width");
        LayoutColumn layoutColumn = (LayoutColumn)new LayoutColumn(width).parseRequiredContent(map, LayoutColumnContent.class);
        LocalIdOptional.parseLocalId(layoutColumn, map);
        return layoutColumn;
    }

    private static Number validateWidth(Number width) {
        Objects.requireNonNull(width, "width");
        double widthAsDouble = width.doubleValue();
        if (widthAsDouble < 0.0 || widthAsDouble > 100.0) {
            throw new LayoutColumnException.InvalidWidth(width);
        }
        return width;
    }
}

