/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.ex.node.HardBreakException;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.type.CaptionContent;
import com.atlassian.adf.model.node.type.InlineContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class HardBreak
extends AbstractNode<HardBreak>
implements CaptionContent,
InlineContent {
    static final Factory<HardBreak> FACTORY = new Factory<HardBreak>("hardBreak", HardBreak.class, HardBreak::parse);
    private static final String NEWLINE = "\n";
    private static final Optional<String> OPTIONAL_NEWLINE = Optional.of("\n");
    private static final HardBreak WITH_TEXT = new HardBreak(true);
    private static final HardBreak WITHOUT_TEXT = new HardBreak(false);
    private final boolean hasText;
    private final Map<String, ?> map;

    public static HardBreak hardBreakWithText() {
        return WITH_TEXT;
    }

    public static HardBreak hardBreak() {
        return WITHOUT_TEXT;
    }

    public static HardBreak br() {
        return WITHOUT_TEXT;
    }

    public boolean hasText() {
        return this.hasText;
    }

    public Optional<String> text() {
        return this.hasText ? OPTIONAL_NEWLINE : Optional.empty();
    }

    private HardBreak(boolean hasText) {
        this.hasText = hasText;
        this.map = hasText ? Map.of("type", "hardBreak", "attrs", Map.of("text", NEWLINE)) : Map.of("type", "hardBreak");
    }

    @Override
    public HardBreak copy() {
        return this;
    }

    @Override
    public String elementType() {
        return "hardBreak";
    }

    @Override
    public void validate() {
    }

    @Override
    protected int nodeHashCode() {
        return Boolean.hashCode(this.hasText);
    }

    @Override
    protected boolean nodeEquals(HardBreak other) {
        return this.hasText == other.hasText;
    }

    @Override
    protected void appendNodeFields(AbstractNode.ToStringHelper buf) {
        if (this.hasText) {
            buf.appendField("hasText", true);
        }
    }

    @Override
    public Map<String, ?> toMap() {
        return this.map;
    }

    private static HardBreak parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "hardBreak");
        String text = ParserSupport.getAttr(map, "text", String.class).orElse(null);
        if (text == null) {
            return HardBreak.br();
        }
        if (NEWLINE.equals(text)) {
            return HardBreak.hardBreakWithText();
        }
        throw new HardBreakException.TextMustBeNewline();
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        sb.append('\n');
    }
}

