/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.LocalIdRequired;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.Text;
import com.atlassian.adf.model.node.type.InlineContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

@Documentation(state=Documentation.State.UNDOCUMENTED, date="2023-07-26")
public class DecisionItem
extends AbstractContentNode<DecisionItem, InlineContent>
implements LocalIdRequired<DecisionItem> {
    static final Factory<DecisionItem> FACTORY = new Factory<DecisionItem>("decisionItem", DecisionItem.class, DecisionItem::parse);
    private String localId;
    private String state;

    private DecisionItem(String localId, String state) {
        this.localId = Objects.requireNonNull(localId, "localId");
        this.state = Objects.requireNonNull(state, "state");
    }

    public static Partial.NeedsLocalId decisionItem() {
        return new Partial.NeedsLocalId();
    }

    @Override
    public Class<InlineContent> contentClass() {
        return InlineContent.class;
    }

    @Override
    public DecisionItem copy() {
        return DecisionItem.parse(this.toMap());
    }

    @Override
    public DecisionItem content(String content) {
        return (DecisionItem)this.content(Text.text(content));
    }

    @Override
    public DecisionItem content(String ... content) {
        return (DecisionItem)this.content(Text.text(content));
    }

    @Override
    public DecisionItem localId(String localId) {
        this.localId = Objects.requireNonNull(localId, "localId");
        return this;
    }

    @Override
    public DecisionItem localId(UUID localId) {
        return this.localId(Objects.requireNonNull(localId, "localId").toString());
    }

    @Override
    public String localId() {
        return this.localId;
    }

    public DecisionItem state(String state) {
        this.state = Objects.requireNonNull(state, "state");
        return this;
    }

    public DecisionItem state(State state) {
        this.state = Objects.requireNonNull(state, "state").name();
        return this;
    }

    public DecisionItem decided() {
        this.state = State.DECIDED.name();
        return this;
    }

    public DecisionItem undecided() {
        this.state = State.UNDECIDED.name();
        return this;
    }

    public String state() {
        return this.state;
    }

    @Override
    public String elementType() {
        return "decisionItem";
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().let(this::addContentIfPresent).add("attrs", FieldMap.map().add("localId", this.localId).add("state", this.state));
    }

    @Override
    protected boolean contentNodeEquals(DecisionItem other) {
        return this.localId.equals(other.localId) && this.state.equals(other.state);
    }

    @Override
    protected int contentNodeHashCode() {
        return Objects.hash(this.localId, this.state);
    }

    @Override
    protected void appendContentNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("localId", this.localId);
        buf.appendField("state", this.state);
    }

    public static DecisionItem parse(Map<String, ?> map) {
        return (DecisionItem)DecisionItem.decisionItem().localId(LocalIdRequired.parseLocalId(map)).state(ParserSupport.getAttrOrThrow(map, "state", String.class)).parseOptionalContent(map, InlineContent.class);
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        sb.append("<> ");
        this.appendPlainTextInlineContent(sb);
    }

    public static interface Partial {

        public static class NeedsState {
            private final String localId;

            NeedsState(String localId) {
                this.localId = Objects.requireNonNull(localId, "localId");
            }

            public DecisionItem state(String state) {
                return new DecisionItem(this.localId, state);
            }

            public DecisionItem state(State state) {
                return new DecisionItem(this.localId, state.name());
            }

            public DecisionItem decided() {
                return new DecisionItem(this.localId, State.DECIDED.name());
            }

            public DecisionItem undecided() {
                return new DecisionItem(this.localId, State.UNDECIDED.name());
            }
        }

        public static class NeedsLocalId {
            NeedsLocalId() {
            }

            public NeedsState localId(String localId) {
                return new NeedsState(localId);
            }

            public NeedsState localId(UUID localId) {
                return new NeedsState(localId.toString());
            }
        }
    }

    public static enum State {
        DECIDED,
        UNDECIDED;

    }
}

