/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.LocalIdOptional;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.Text;
import com.atlassian.adf.model.node.type.CaptionContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@Documentation(state=Documentation.State.UNDOCUMENTED, date="2023-07-26")
public class Caption
extends AbstractContentNode<Caption, CaptionContent>
implements LocalIdOptional<Caption> {
    static final Factory<Caption> FACTORY = new Factory<Caption>("caption", Caption.class, Caption::parse);
    @Nullable
    private String localId;

    private Caption() {
    }

    public static Caption caption() {
        return new Caption();
    }

    public static Caption caption(String content) {
        return new Caption().content(content);
    }

    public static Caption caption(String ... content) {
        return new Caption().content(content);
    }

    public static Caption caption(CaptionContent content) {
        return (Caption)new Caption().content(content);
    }

    public static Caption caption(CaptionContent ... content) {
        return (Caption)new Caption().content(content);
    }

    public static Caption caption(Iterable<? extends CaptionContent> content) {
        return (Caption)new Caption().content(content);
    }

    public static Caption caption(Stream<? extends CaptionContent> content) {
        return (Caption)new Caption().content(content);
    }

    @Override
    public Caption content(String content) {
        return (Caption)this.content(Text.text(content));
    }

    @Override
    public Caption content(String ... content) {
        return (Caption)this.content(Text.text(content));
    }

    @Override
    public Caption localId(@Nullable String localId) {
        this.localId = localId;
        return this;
    }

    @Override
    public Optional<String> localId() {
        return Optional.ofNullable(this.localId);
    }

    @Override
    public Class<CaptionContent> contentClass() {
        return CaptionContent.class;
    }

    @Override
    public Caption copy() {
        return Caption.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "caption";
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        this.appendPlainTextInlineContent(sb);
    }

    @Override
    protected int contentNodeHashCode() {
        return Objects.hashCode(this.localId);
    }

    @Override
    protected boolean contentNodeEquals(Caption other) {
        return Objects.equals(this.localId, other.localId);
    }

    @Override
    protected void appendContentNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("localId", this.localId);
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().let(this::addContent).addIf(this.localId != null, "attrs", () -> FieldMap.map("localId", this.localId));
    }

    private static Caption parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "caption");
        Caption caption = (Caption)new Caption().parseOptionalContent(map, CaptionContent.class);
        LocalIdOptional.parseLocalId(caption, map);
        return caption;
    }
}

