/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.LocalIdOptional;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.ListItem;
import com.atlassian.adf.model.node.type.ListItemContent;
import com.atlassian.adf.model.node.type.ListNode;
import com.atlassian.adf.util.Cast;
import com.atlassian.annotations.Internal;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@Internal
public abstract class AbstractListNode<L extends AbstractListNode<L>>
extends AbstractContentNode<L, ListItem>
implements LocalIdOptional<L>,
ListNode<L> {
    @Nullable
    protected String localId;

    AbstractListNode() {
    }

    @Override
    public L localId(@Nullable String localId) {
        this.localId = localId;
        return (L)((AbstractListNode)Cast.unsafeCast(this));
    }

    @Override
    public Optional<String> localId() {
        return Optional.ofNullable(this.localId);
    }

    @Override
    protected void appendContentNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("localId", this.localId);
    }

    @Override
    protected boolean contentNodeEquals(L other) {
        return Objects.equals(this.localId, ((AbstractListNode)other).localId);
    }

    @Override
    protected int contentNodeHashCode() {
        return Objects.hashCode(this.localId);
    }

    @Override
    public Class<ListItem> contentClass() {
        return ListItem.class;
    }

    @Override
    public L li(String content) {
        return (L)((AbstractListNode)this.content(ListItem.listItem(content)));
    }

    @Override
    public L li(String ... content) {
        return (L)((AbstractListNode)this.content(ListItem.listItem(content)));
    }

    @Override
    public L li(ListItemContent content) {
        return (L)((AbstractListNode)this.content(ListItem.listItem(content)));
    }

    @Override
    public L li(ListItemContent ... content) {
        return (L)((AbstractListNode)this.content(ListItem.listItem(content)));
    }

    @Override
    public L li(Iterable<? extends ListItemContent> content) {
        return (L)((AbstractListNode)this.content(ListItem.listItem(content)));
    }

    @Override
    public L li(Stream<? extends ListItemContent> content) {
        return (L)((AbstractListNode)this.content(ListItem.listItem(content)));
    }

    @Override
    protected void contentNodeValidate() {
        this.requireNotEmpty();
    }
}

