/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.ctx;

import com.atlassian.adf.ctx.DefaultFeatureProvider;
import com.atlassian.adf.ctx.Feature;
import com.atlassian.adf.ctx.FeatureProvider;
import com.atlassian.adf.ctx.FeatureSet;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class Context {
    private static final Context DEFAULTS = new Builder().build();
    private static final ThreadLocal<Context> CURRENT = ThreadLocal.withInitial(() -> DEFAULTS);
    private final FeatureProvider featureProvider;

    private Context(Builder builder) {
        this.featureProvider = builder.featureProvider;
    }

    public static Context current() {
        return CURRENT.get();
    }

    public static Context withFeature(Feature feature) {
        return Context.withFeature(feature, true);
    }

    public static Context withFeature(Feature feature, boolean enabled) {
        Objects.requireNonNull(feature, "feature");
        Context ctx = CURRENT.get();
        FeatureProvider delegate = ctx.featureProvider;
        return ctx.copy().featureProvider(feat -> feat == feature ? enabled : delegate.enabled(feat)).build();
    }

    public static Context withFeatures(FeatureSet featureSet) {
        Objects.requireNonNull(featureSet, "featureSet");
        Context ctx = CURRENT.get();
        FeatureProvider featureProvider = ctx.featureProvider.withOverrides(featureSet);
        return ctx.copy().featureProvider(featureProvider).build();
    }

    public static Context withFeatureProvider(@Nullable FeatureProvider featureProvider) {
        FeatureProvider delegate = featureProvider != null ? featureProvider : DefaultFeatureProvider.getInstance();
        Context ctx = CURRENT.get();
        return ctx.copy().featureProvider(delegate).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Supplier<T> supplier) {
        Context saved = CURRENT.get();
        try {
            CURRENT.set(this);
            T t = supplier.get();
            return t;
        }
        finally {
            CURRENT.set(saved);
        }
    }

    public void run(Runnable runnable) {
        this.get(() -> {
            runnable.run();
            return Boolean.TRUE;
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder copy() {
        return new Builder(this);
    }

    public FeatureProvider featureProvider() {
        return this.featureProvider;
    }

    public static class Builder {
        private FeatureProvider featureProvider;

        Builder() {
            this.featureProvider = DefaultFeatureProvider.getInstance();
        }

        Builder(Context proto) {
            this.featureProvider = proto.featureProvider;
        }

        public Builder featureProvider(@Nullable FeatureProvider featureProvider) {
            this.featureProvider = featureProvider != null ? featureProvider : DefaultFeatureProvider.getInstance();
            return this;
        }

        public Context build() {
            return new Context(this);
        }
    }
}

