/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.dbexporter;

import com.atlassian.dbexporter.Context;
import com.atlassian.dbexporter.exporter.ExportConfiguration;
import com.atlassian.dbexporter.exporter.Exporter;
import com.atlassian.dbexporter.node.NodeBackup;
import com.atlassian.dbexporter.node.NodeCreator;
import com.atlassian.dbexporter.node.NodeStreamWriter;
import com.atlassian.dbexporter.progress.ProgressMonitor;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;

public final class DbExporter {
    private final List<Exporter> exporters;

    public DbExporter(Exporter ... exporters) {
        this(Lists.newArrayList((Object[])((Object[])Preconditions.checkNotNull((Object)exporters))));
    }

    public DbExporter(List<Exporter> exporters) {
        Preconditions.checkArgument((!((List)Preconditions.checkNotNull(exporters)).isEmpty() ? 1 : 0) != 0, (Object)"DbExporter must be created with at least one Exporter!");
        this.exporters = exporters;
    }

    public void exportData(NodeStreamWriter streamWriter, ExportConfiguration configuration) {
        ProgressMonitor monitor = configuration.getProgressMonitor();
        monitor.begin(new Object[0]);
        NodeCreator node = NodeBackup.RootNode.add(streamWriter);
        Context context = new Context(new Object[0]);
        for (Exporter exporter : this.exporters) {
            exporter.export(node, configuration, context);
        }
        monitor.end(new Object[0]);
    }
}

