/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.activeobjects.backup;

import com.atlassian.dbexporter.Column;
import com.atlassian.dbexporter.ImportExportErrorService;
import com.atlassian.dbexporter.Table;
import com.atlassian.dbexporter.jdbc.JdbcUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.java.ao.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SqlUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"net.java.ao.sql");

    SqlUtils() {
    }

    static Iterable<TableColumnPair> tableColumnPairs(Iterable<Table> tables) {
        return Iterables.concat((Iterable)Iterables.transform(tables, (Function)new AutoIncrementColumnIterableFunction()));
    }

    static void executeUpdate(ImportExportErrorService errorService, String tableName, Statement s, String sql) {
        try {
            if (!StringUtils.isBlank(sql)) {
                LOGGER.debug(sql);
                s.executeUpdate(sql);
            }
        }
        catch (SQLException e) {
            SqlUtils.onSqlException(errorService, tableName, sql, e);
        }
    }

    private static void onSqlException(ImportExportErrorService errorService, String table, String sql, SQLException e) {
        if (sql.startsWith("DROP") && e.getMessage().contains("does not exist")) {
            LOGGER.debug("Ignoring exception for SQL <" + sql + ">", (Throwable)e);
            return;
        }
        throw errorService.newImportExportSqlException(table, "Error executing update for SQL statement '" + sql + "'", e);
    }

    static void executeUpdate(ImportExportErrorService errorService, String tableName, Connection connection, String sql) {
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            SqlUtils.executeUpdate(errorService, tableName, stmt, sql);
        }
        catch (SQLException e) {
            try {
                throw errorService.newImportExportSqlException(tableName, "", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(new Statement[]{stmt});
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly(new Statement[]{stmt});
    }

    static int getIntFromResultSet(ImportExportErrorService errorService, String tableName, ResultSet res) {
        try {
            return res.next() ? res.getInt(1) : 1;
        }
        catch (SQLException e) {
            throw errorService.newImportExportSqlException(tableName, "Error getting int value from result set.", e);
        }
    }

    static ResultSet executeQuery(ImportExportErrorService errorService, String tableName, Statement s, String sql) {
        try {
            return s.executeQuery(sql);
        }
        catch (SQLException e) {
            throw errorService.newImportExportSqlException(tableName, "Error executing query for SQL statement '" + sql + "'", e);
        }
    }

    private static class IsAutoIncrementColumn
    implements Predicate<Column> {
        private IsAutoIncrementColumn() {
        }

        public boolean apply(Column column) {
            return column.isAutoIncrement();
        }
    }

    private static class AutoIncrementColumnIterableFunction
    implements Function<Table, Iterable<TableColumnPair>> {
        private AutoIncrementColumnIterableFunction() {
        }

        public Iterable<TableColumnPair> apply(final Table table) {
            return Iterables.transform((Iterable)Iterables.filter(table.getColumns(), (Predicate)new IsAutoIncrementColumn()), (Function)new Function<Column, TableColumnPair>(){

                public TableColumnPair apply(Column column) {
                    return new TableColumnPair(table, column);
                }
            });
        }
    }

    static class TableColumnPair {
        final Table table;
        final Column column;

        public TableColumnPair(Table table, Column column) {
            this.table = (Table)Preconditions.checkNotNull((Object)table);
            this.column = (Column)Preconditions.checkNotNull((Object)column);
        }
    }
}

