/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.activeobjects.servlet;

import com.atlassian.activeobjects.servlet.AdminUi;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class AdminUiFilter
implements Filter {
    private final AdminUi adminUi;

    public AdminUiFilter(AdminUi adminUi) {
        this.adminUi = (AdminUi)Preconditions.checkNotNull((Object)adminUi);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, filterChain);
            return;
        }
        filterChain.doFilter(request, response);
    }

    private void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.adminUi.isEnabled()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else if (AdminUi.isDevModeEnabled().booleanValue()) {
            response.sendError(404, "The Active Objects admin UI is disabled, see the logs for more information.");
        } else {
            response.sendError(404);
        }
    }

    public void destroy() {
    }
}

