/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao;

import com.google.common.base.Preconditions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.List;
import net.java.ao.Common;
import net.java.ao.DatabaseProvider;
import net.java.ao.EntityManager;
import net.java.ao.EntityManagerConfiguration;
import net.java.ao.LuceneConfiguration;
import net.java.ao.RawEntity;
import net.java.ao.Searchable;
import net.java.ao.schema.info.EntityInfo;
import net.java.ao.types.TypeInfo;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;

public class SearchableEntityManager
extends EntityManager {
    private final Directory indexDir;
    private final Analyzer analyzer;

    public SearchableEntityManager(DatabaseProvider databaseProvider, EntityManagerConfiguration configuration, LuceneConfiguration luceneConfiguration) throws IOException {
        super(databaseProvider, configuration);
        this.indexDir = (Directory)Preconditions.checkNotNull((Object)((LuceneConfiguration)Preconditions.checkNotNull((Object)luceneConfiguration)).getIndexDirectory());
        this.analyzer = new StopAnalyzer();
        this.init();
    }

    @Override
    protected <T extends RawEntity<K>, K> T getAndInstantiate(EntityInfo<T, K> entityInfo, K key) {
        T back = super.getAndInstantiate(entityInfo, key);
        back.addPropertyChangeListener(new IndexAppender(this, (RawEntity)back));
        return back;
    }

    public <T extends RawEntity<K>, K> T[] search(Class<T> type, String strQuery) throws IOException, ParseException, SQLException {
        EntityInfo entityInfo = this.resolveEntityInfo(type);
        String table = this.getTableNameConverter().getName(type);
        List<String> indexFields = Common.getSearchableFields(this, type);
        String[] searchFields = new String[indexFields.size()];
        String primaryKeyField = Common.getPrimaryKeyField(type, this.getFieldNameConverter());
        TypeInfo dbType = entityInfo.getPrimaryKey().getTypeInfo();
        for (int i = 0; i < searchFields.length; ++i) {
            searchFields[i] = table + '.' + indexFields.get(i);
        }
        IndexSearcher searcher = new IndexSearcher(this.indexDir);
        MultiFieldQueryParser parser = new MultiFieldQueryParser(searchFields, this.analyzer);
        Query query = parser.parse(strQuery);
        Hits hits = searcher.search(query);
        Object[] keys = new Object[hits.length()];
        for (int i = 0; i < hits.length(); ++i) {
            keys[i] = dbType.getLogicalType().parseDefault(hits.doc(i).get(table + "." + primaryKeyField));
        }
        searcher.close();
        return this.peer(entityInfo, keys);
    }

    @Override
    public void delete(RawEntity<?> ... entities) throws SQLException {
        super.delete(entities);
        IndexReader reader = null;
        try {
            reader = IndexReader.open((Directory)this.indexDir);
            for (RawEntity<?> entity : entities) {
                this.removeFromIndexImpl(entity, reader);
            }
        }
        catch (IOException e) {
            throw (SQLException)new SQLException().initCause(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void addToIndex(RawEntity<?> entity) throws IOException {
        String table = this.getTableNameConverter().getName(entity.getEntityType());
        IndexWriter writer = null;
        try {
            writer = new IndexWriter(this.indexDir, this.analyzer, false);
            Document doc = new Document();
            doc.add((Fieldable)new Field(this.getTableNameConverter().getName(entity.getEntityType()) + "." + Common.getPrimaryKeyField(entity.getEntityType(), this.getFieldNameConverter()), this.primaryKeyToString(entity), Field.Store.YES, Field.Index.UN_TOKENIZED));
            boolean shouldAdd = false;
            for (Method m : entity.getEntityType().getMethods()) {
                Searchable indexAnno = Common.getAnnotationDelegate(this.getFieldNameConverter(), m).getAnnotation(Searchable.class);
                if (indexAnno == null) continue;
                shouldAdd = true;
                if (!Common.isAccessor(m)) continue;
                String attribute = this.getFieldNameConverter().getName(m);
                Object value = m.invoke(entity, new Object[0]);
                if (value == null) continue;
                doc.add((Fieldable)new Field(table + '.' + attribute, value.toString(), Field.Store.YES, Field.Index.TOKENIZED));
            }
            if (shouldAdd) {
                writer.addDocument(doc);
            }
        }
        catch (IllegalArgumentException e) {
            throw (IOException)new IOException().initCause(e);
        }
        catch (IllegalAccessException e) {
            throw (IOException)new IOException().initCause(e);
        }
        catch (InvocationTargetException e) {
            throw (IOException)new IOException().initCause(e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromIndex(RawEntity<?> entity) throws IOException {
        IndexReader reader = null;
        try {
            reader = IndexReader.open((Directory)this.indexDir);
            this.removeFromIndexImpl(entity, reader);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private void removeFromIndexImpl(RawEntity<?> entity, IndexReader reader) throws IOException {
        reader.deleteDocuments(new Term(this.getTableNameConverter().getName(entity.getEntityType()) + "." + Common.getPrimaryKeyField(entity.getEntityType(), this.getFieldNameConverter()), this.primaryKeyToString(entity)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimize() throws IOException {
        IndexWriter writer = null;
        try {
            writer = new IndexWriter(this.indexDir, this.analyzer, false);
            writer.optimize();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public Directory getIndexDir() {
        return this.indexDir;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    private void init() throws IOException {
        if (!IndexReader.indexExists((Directory)this.indexDir)) {
            new IndexWriter(this.indexDir, this.analyzer, true).close();
        }
    }

    private final String primaryKeyToString(RawEntity<?> entity) {
        TypeInfo pkType = Common.getPrimaryKeyType(this.getProvider().getTypeManager(), entity.getEntityType());
        return pkType.getLogicalType().valueToString(Common.getPrimaryKeyValue(entity));
    }

    private static class IndexAppender<T extends RawEntity<K>, K>
    implements PropertyChangeListener {
        private List<String> indexFields;
        private Document doc;
        final /* synthetic */ SearchableEntityManager this$0;

        private IndexAppender(T entity) {
            this.this$0 = var1_1;
            this.indexFields = Common.getSearchableFields(var1_1, entity.getEntityType());
            this.doc = new Document();
            this.doc.add((Fieldable)new Field(var1_1.getTableNameConverter().getName(entity.getEntityType()) + "." + Common.getPrimaryKeyField(entity.getEntityType(), var1_1.getFieldNameConverter()), ((SearchableEntityManager)var1_1).primaryKeyToString(entity), Field.Store.YES, Field.Index.UN_TOKENIZED));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.indexFields.contains(evt.getPropertyName())) {
                RawEntity entity = (RawEntity)evt.getSource();
                this.doc.add((Fieldable)new Field(this.this$0.getTableNameConverter().getName(entity.getEntityType()) + '.' + evt.getPropertyName(), evt.getNewValue().toString(), Field.Store.YES, Field.Index.TOKENIZED));
                IndexWriter writer = null;
                try {
                    writer = new IndexWriter(this.this$0.getIndexDir(), this.this$0.getAnalyzer(), false);
                    writer.updateDocument(new Term(this.this$0.getTableNameConverter().getName(entity.getEntityType()) + "." + Common.getPrimaryKeyField(entity.getEntityType(), this.this$0.getFieldNameConverter()), this.this$0.primaryKeyToString(entity)), this.doc);
                }
                catch (IOException e) {
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (CorruptIndexException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

