/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.activeobjects.confluence;

import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.activeobjects.spi.DefaultInitExecutorServiceProvider;
import com.atlassian.activeobjects.spi.InitExecutorServiceProvider;
import com.atlassian.activeobjects.spi.TenantAwareDataSourceProvider;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.atlassian.tenancy.api.Tenant;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceInitExecutorServiceProvider
implements InitExecutorServiceProvider {
    private static final Logger logger = LoggerFactory.getLogger(DefaultInitExecutorServiceProvider.class);
    private final TenantAwareDataSourceProvider tenantAwareDataSourceProvider;
    private final ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory;
    @VisibleForTesting
    final InitExecutorServiceProvider defaultInitExecutorServiceProvider;

    public ConfluenceInitExecutorServiceProvider(ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory, TenantAwareDataSourceProvider tenantAwareDataSourceProvider, InitExecutorServiceProvider defaultInitExecutorServiceProvider) {
        this.threadLocalDelegateExecutorFactory = (ThreadLocalDelegateExecutorFactory)Preconditions.checkNotNull((Object)threadLocalDelegateExecutorFactory);
        this.tenantAwareDataSourceProvider = (TenantAwareDataSourceProvider)Preconditions.checkNotNull((Object)tenantAwareDataSourceProvider);
        this.defaultInitExecutorServiceProvider = (InitExecutorServiceProvider)Preconditions.checkNotNull((Object)defaultInitExecutorServiceProvider);
    }

    @Override
    @Nonnull
    public ExecutorService initExecutorService(@Nonnull Tenant tenant) {
        DatabaseType databaseType = this.tenantAwareDataSourceProvider.getDatabaseType(tenant);
        if (DatabaseType.HSQL.equals((Object)databaseType)) {
            logger.debug("creating HSQL snowflake init executor");
            return this.threadLocalDelegateExecutorFactory.createExecutorService((ExecutorService)MoreExecutors.newDirectExecutorService());
        }
        return this.defaultInitExecutorServiceProvider.initExecutorService(tenant);
    }
}

