/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz3B;
import asposewobfuscated.zzKT;
import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IWarningCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.SwfSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;

public abstract class SaveOptions {
    private boolean zzYP2;
    private boolean zzYP1 = true;
    private boolean zzzb;
    private String zzYP0;
    private boolean zzYOZ;
    private boolean zzYOY = false;
    private int zzYOX = 0;
    private int zzLV = 0;
    private IWarningCallback zz7v;

    protected SaveOptions() {
    }

    boolean zzZoP() {
        return this.zzYP2;
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzZRY() {
        return false;
    }

    boolean zzZT8() {
        return true;
    }

    boolean zzZoO() {
        return this.zzYP1;
    }

    public String getTempFolder() {
        return this.zzYP0;
    }

    public void setTempFolder(String value) {
        this.zzYP0 = value;
    }

    public boolean getPrettyFormat() {
        return this.zzzb;
    }

    public void setPrettyFormat(boolean value) {
        this.zzzb = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzYOZ;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzYOZ = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzYOY;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzYOY = value;
    }

    public int getDmlRenderingMode() {
        return this.zzYOX;
    }

    public void setDmlRenderingMode(int value) {
        this.zzYOX = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzLV;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzLV = value;
    }

    public IWarningCallback getWarningCallback() {
        return this.zz7v;
    }

    public void setWarningCallback(IWarningCallback value) {
        this.zz7v = value;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 43: {
                return new SwfSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 100: 
            case 101: 
            case 102: 
            case 104: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzMb(zzKT.zzZP(zz3B.zzWy(fileName))));
    }
}

