/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz24;
import asposewobfuscated.zzXG;
import com.aspose.words.Cell;
import com.aspose.words.Comment;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.HeaderFooter;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.ListLabel;
import com.aspose.words.ListLevel;
import com.aspose.words.Node;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.Run;
import com.aspose.words.RunCollection;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.Style;
import com.aspose.words.TabStop;
import com.aspose.words.Table;
import com.aspose.words.zz1Q;
import com.aspose.words.zz4B;
import com.aspose.words.zz4X;
import com.aspose.words.zz5A;
import com.aspose.words.zz5G;
import com.aspose.words.zz5O;
import com.aspose.words.zzC;
import com.aspose.words.zzCZ;
import com.aspose.words.zzD4;
import com.aspose.words.zzLG;
import com.aspose.words.zzZK7;
import com.aspose.words.zzZQM;
import com.aspose.words.zzZX7;

public class Paragraph
extends CompositeNode
implements zz4X,
zz5A,
zz5G {
    private zzZQM zzZzf;
    private zzZK7 zzZ2J;
    private ParagraphFormat zzZ2I;
    private ListFormat zzZoc;
    private ListFormat zzZ2H;
    private ListLabel zzZ2G;
    private RunCollection zzZ2F;

    public Paragraph(DocumentBase doc) {
        this(doc, new zzZQM(), new zzZK7());
    }

    Paragraph(DocumentBase doc, zzZQM paraPr, zzZK7 runPr) {
        super(doc);
        this.zzZzf = paraPr;
        this.zzZ2J = runPr;
    }

    @Override
    public int getNodeType() {
        return 8;
    }

    public Story getParentStory() {
        return (Story)this.getAncestor(Story.class);
    }

    public Section getParentSection() {
        return (Section)this.getAncestor(2);
    }

    public boolean isInCell() {
        return this.zzZER() instanceof Cell;
    }

    boolean zzZwV() {
        CompositeNode compositeNode = this.getParentNode();
        if (compositeNode == null) {
            return false;
        }
        if (zzZX7.zzZI(compositeNode)) {
            return this.isInCell() && this.zz8(this.zzZER().getFirstChild());
        }
        return this.isInCell() && this == compositeNode.getFirstChild();
    }

    public boolean isEndOfCell() {
        CompositeNode compositeNode = this.zzZER();
        return compositeNode instanceof Cell && compositeNode.zzgy() == this;
    }

    boolean zzZwU() {
        return this.isEndOfCell() && this.zz36().isLastCell();
    }

    Cell zz36() {
        return (Cell)this.zzZER();
    }

    Row getParentRow() {
        return this.zz36().getParentRow();
    }

    Table getParentTable() {
        return this.getParentRow().getParentTable();
    }

    boolean zzZwT() {
        return this.zzZER() instanceof Shape;
    }

    public boolean isEndOfSection() {
        Story story = this.getParentStory();
        return story != null && story.getStoryType() == 1 && this == story.zzgy();
    }

    public boolean isEndOfHeaderFooter() {
        Story story = this.getParentStory();
        return story instanceof HeaderFooter && story.zzgy() == this;
    }

    public boolean isEndOfDocument() {
        if (!this.isEndOfSection()) {
            return false;
        }
        for (Node node = this.getDocument().getLastChild(); node != null; node = node.getPreviousSibling()) {
            if (!(node instanceof Section)) continue;
            return node == this.getParentSection();
        }
        return true;
    }

    public ParagraphFormat getParagraphFormat() {
        if (this.zzZ2I == null) {
            this.zzZ2I = new ParagraphFormat(this, this.getDocument().getStyles());
        }
        return this.zzZ2I;
    }

    public ListFormat getListFormat() {
        if (this.zzZoc == null) {
            this.zzZoc = new ListFormat(this, this.getDocument().getLists());
        }
        return this.zzZoc;
    }

    ListFormat zzZwS() throws Exception {
        if (this.zzZ2H == null) {
            this.zzZ2H = new ListFormat((Paragraph)this.deepClone(false), this.getDocument().getLists());
        }
        return this.zzZ2H;
    }

    public ListLabel getListLabel() throws Exception {
        if (this.zzZ2G == null) {
            this.zzZ2G = new ListLabel(this);
        }
        return this.zzZ2G;
    }

    public RunCollection getRuns() {
        if (this.zzZ2F == null) {
            this.zzZ2F = new RunCollection(this);
        }
        return this.zzZ2F;
    }

    public Font getParagraphBreakFont() {
        return new Font(this, this.getDocument());
    }

    public boolean isInsertRevision() {
        return this.zzZ2J.zzZbO();
    }

    public boolean isDeleteRevision() {
        return this.zzZ2J.zzZbP();
    }

    Style zzZwR() throws Exception {
        return this.getDocument().getStyles().zzYe(this.zzZzf.zzZVQ(), 0);
    }

    Style zzZwQ() throws Exception {
        return this.getDocument().getStyles().zzYe(this.zzZ2J.zzZVQ(), 10);
    }

    zzZQM zzZUi() {
        return this.zzZzf;
    }

    void zzS(zzZQM zzZQM2) {
        this.zzZzf = zzZQM2;
    }

    void zzY(String[] stringArray, zz1Q zz1Q2) throws Exception {
        this.getListLabel().zzZ(stringArray, zz1Q2.zzZKI());
    }

    void zzZwP() throws Exception {
        if (this.zzZ2G != null) {
            this.getListLabel().zzZ(null, null);
        }
    }

    zzZK7 zzZwO() {
        return this.zzZ2J;
    }

    void zzR(zzZK7 zzZK72) {
        this.zzZ2J = zzZK72;
    }

    @Override
    Node zzZ(boolean bl, zz5O zz5O2) throws Exception {
        zzZK7 zzZK72;
        zzZQM zzZQM2;
        Paragraph paragraph = (Paragraph)super.zzZ(bl, zz5O2);
        paragraph.zzZzf = zzZQM2 = (zzZQM)this.zzZzf.zzmm();
        paragraph.zzZ2J = zzZK72 = (zzZK7)this.zzZ2J.zzmm();
        paragraph.zzZ2I = null;
        paragraph.zzZoc = null;
        paragraph.zzZ2G = null;
        paragraph.zzZ2F = null;
        return paragraph;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    int zzZ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitParagraphStart(this);
    }

    @Override
    int zzY(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitParagraphEnd(this);
    }

    @Override
    public String getText() {
        return super.getText();
    }

    zzZQM zzL2(int n) throws Exception {
        zzZQM zzZQM2 = new zzZQM();
        this.zzZ(zzZQM2, n);
        if (this.zzZwT()) {
            zzZQM2.zzZx3();
        }
        return zzZQM2;
    }

    void zzZ(zzZQM zzZQM2, int n) throws Exception {
        Cloneable cloneable;
        if ((n & 1) != 0) {
            this.getDocument().getStyles().zzZhR().zzZ(zzZQM2);
        }
        if ((n & 4) != 0 && (cloneable = (Table)this.getAncestor(5)) != null) {
            ((Table)cloneable).getStyle().zzZ(zzZQM2, n);
        }
        cloneable = this.zzZzf.zzE7(n);
        if ((n & 0x10) != 0 && this.zzZzf.zzZbQ()) {
            zzZQM2.zzZ((zzCZ)this.zzZzf.zzZbL().deepCloneComplexAttr());
        }
        Style style = this.getDocument().getStyles().zzYe(((zzZQM)cloneable).zzZVQ(), 0);
        style.zzZ(zzZQM2, n);
        if (zzZQM2.getListId() != ((zzZQM)cloneable).getListId()) {
            this.getDocument().getLists().zzY((zzZQM)cloneable, zzZQM2);
        }
        if ((n & 8) != 0) {
            this.getDocument().zz9P().zzZ(this.zzZzf, zzZQM2);
        }
        ((zzC)cloneable).zzZ(zzZQM2);
        if ((n & 2) != 0) {
            zzZQM2.zzZx2();
        }
    }

    zzZK7 zzE3(int n) throws Exception {
        zzZK7 zzZK72 = new zzZK7();
        this.zzX(zzZK72, n);
        return zzZK72;
    }

    void zzX(zzZK7 zzZK72, int n) throws Exception {
        zz4B.zzZ(this.getDocument(), zz4B.zzY(this, n), this.zzZwQ(), null, this.zzZ2J.zzBS(n), zzZK72, n);
    }

    boolean zzZwN() {
        CompositeNode compositeNode = this.zzZER();
        return compositeNode instanceof Comment && this == compositeNode.zzgy();
    }

    boolean zzZwM() {
        CompositeNode compositeNode = this.zzZER();
        return compositeNode instanceof Footnote && this == compositeNode.zzgy();
    }

    boolean zzZwL() {
        CompositeNode compositeNode = this.zzZER();
        return compositeNode instanceof zzD4 && this == compositeNode.zzgy();
    }

    boolean zzZwK() {
        CompositeNode compositeNode = this.zzZER();
        return compositeNode instanceof Shape && compositeNode.zzgy() == this;
    }

    void zzZ(double[] dArray, double[] dArray2, boolean[] blArray) throws Exception {
        dArray[0] = 2.147483647E9;
        dArray2[0] = 0.0;
        blArray[0] = false;
        for (Node node = this.zzgz(); node != null; node = node.zzZEP()) {
            if (!(node instanceof Inline)) continue;
            Paragraph.zzZ((Inline)node, dArray, dArray2, blArray);
        }
        if (dArray2[0] == 0.0) {
            Paragraph.zzZ(this, dArray, dArray2, blArray);
        }
    }

    private static void zzZ(zz5A zz5A2, double[] dArray, double[] dArray2, boolean[] blArray) throws Exception {
        Object object = zz5A2.getDirectRunAttr(190);
        double d = zzXG.zzZK((Integer)(object != null ? object : zz5A2.fetchInheritedRunAttr(190)));
        dArray[0] = Math.min(d, dArray[0]);
        dArray2[0] = Math.max(d, dArray2[0]);
        if (!blArray[0]) {
            boolean bl = blArray[0] = object != null;
            if (!blArray[0]) {
                Object object2 = zz5A2.getDirectRunAttr(50);
                blArray[0] = object2 != null && (Integer)object2 != 10;
            }
        }
    }

    @Override
    String zzgx() {
        if (this.isEndOfCell()) {
            return ControlChar.CELL;
        }
        if (this.isEndOfSection()) {
            return ControlChar.SECTION_BREAK;
        }
        return ControlChar.PARAGRAPH_BREAK;
    }

    @Override
    boolean zzR(Node node) {
        return zzZX7.zzZK(node);
    }

    @Override
    @ReservedForInternalUse
    public Object getDirectParaAttr(int key) {
        return this.zzZzf.zzS0(key);
    }

    @Override
    @ReservedForInternalUse
    public int getDirectParaAttrsCount() {
        return this.zzZzf.getCount();
    }

    @Override
    @ReservedForInternalUse
    public void getDirectParaAttrByIndex(int index, int[] key, Object[] value) {
        key[0] = this.zzZzf.zzTQ(index);
        value[0] = this.zzZzf.zzVY(index);
    }

    @Override
    @ReservedForInternalUse
    public Object fetchInheritedParaAttr(int key) throws Exception {
        ListLevel listLevel = this.getDocument().getLists().zzW(this.zzZUi());
        if (listLevel != null) {
            Object object = listLevel.zzZUi().zzS0(key);
            if (object != null) {
                return object;
            }
        } else if (this.zzZzf.zzZxy() && (key == 1160 || key == 1170)) {
            return 0;
        }
        return this.zzZwR().fetchParaAttr(key);
    }

    @Override
    @ReservedForInternalUse
    public Object fetchParaAttr(int key) throws Exception {
        Object object = this.getDirectParaAttr(key);
        return object != null ? object : this.fetchInheritedParaAttr(key);
    }

    @Override
    @ReservedForInternalUse
    public void setParaAttr(int key, Object value) {
        this.zzZzf.zzW(key, value);
    }

    @Override
    @ReservedForInternalUse
    public void removeParaAttr(int key) {
        this.zzZzf.remove(key);
    }

    @Override
    @ReservedForInternalUse
    public void clearParaAttrs() {
        this.zzZzf.zzmo();
    }

    @Override
    @ReservedForInternalUse
    public Object getDirectRunAttr(int key) {
        return this.zzZ2J.zzS0(key);
    }

    @Override
    @ReservedForInternalUse
    public int getDirectRunAttrsCount() {
        return this.zzZ2J.getCount();
    }

    @Override
    @ReservedForInternalUse
    public void getDirectRunAttrByIndex(int index, int[] key, Object[] value) {
        key[0] = this.zzZ2J.zzTQ(index);
        value[0] = this.zzZ2J.zzVY(index);
    }

    @Override
    @ReservedForInternalUse
    public Object fetchInheritedRunAttr(int key) throws Exception {
        Object object = this.zzZwQ().zzZV(key, false);
        if (object != null) {
            return object;
        }
        return this.zzZwR().zzZV(key, true);
    }

    @Override
    @ReservedForInternalUse
    public void setRunAttr(int key, Object value) {
        this.zzZ2J.zzW(key, value);
    }

    @Override
    @ReservedForInternalUse
    public void removeRunAttr(int key) {
        this.zzZ2J.remove(key);
    }

    @Override
    @ReservedForInternalUse
    public void clearRunAttrs() {
        this.zzZ2J.zzmo();
    }

    @Override
    @ReservedForInternalUse
    public zzLG getInsertRevision() {
        return this.zzZwO().getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    public void setInsertRevision(zzLG value) {
        this.zzZwO().setInsertRevision(value);
    }

    @ReservedForInternalUse
    public zzLG getDeleteRevision() {
        return this.zzZwO().getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    public void setDeleteRevision(zzLG value) {
        this.zzZwO().setDeleteRevision(value);
    }

    boolean zzZwJ() throws Exception {
        double d;
        Node node = this.zzZEP();
        if (!(node instanceof Paragraph)) {
            return false;
        }
        Paragraph paragraph = (Paragraph)node;
        ParagraphFormat paragraphFormat = this.getParagraphFormat();
        ParagraphFormat paragraphFormat2 = paragraph.getParagraphFormat();
        if (paragraphFormat2.getPageBreakBefore()) {
            return false;
        }
        double d2 = paragraphFormat.getLeftIndent() + Math.min(paragraphFormat.getFirstLineIndent(), 0.0);
        if (d2 != (d = paragraphFormat2.getLeftIndent() + Math.min(paragraphFormat2.getFirstLineIndent(), 0.0))) {
            return false;
        }
        if (paragraphFormat.getRightIndent() != paragraphFormat2.getRightIndent()) {
            return false;
        }
        if (!paragraphFormat.getBorders().getByBorderType(1).zzZ(paragraphFormat2.getBorders().getByBorderType(1))) {
            return false;
        }
        if (!paragraphFormat.getBorders().getByBorderType(2).zzZ(paragraphFormat2.getBorders().getByBorderType(2))) {
            return false;
        }
        if (!paragraphFormat.getBorders().getByBorderType(3).zzZ(paragraphFormat2.getBorders().getByBorderType(3))) {
            return false;
        }
        if (!paragraphFormat.getBorders().getByBorderType(0).zzZ(paragraphFormat2.getBorders().getByBorderType(0))) {
            return false;
        }
        return this.zzZC(paragraph);
    }

    boolean zzZC(Paragraph paragraph) {
        return this.zzZzf.zzR(paragraph.zzZUi());
    }

    Run zzZwI() {
        return (Run)this.getChild(21, 0, false);
    }

    Run zzZwH() {
        Run run = null;
        for (Node node = this.zzgz(); node != null; node = node.zzZEP()) {
            if (node.getNodeType() != 21) continue;
            run = (Run)node;
        }
        return run;
    }

    boolean zzZVW() {
        Story story = this.getParentStory();
        return story != null && story.getStoryType() == 1;
    }

    public boolean isListItem() throws Exception {
        return (Integer)this.fetchParaAttr(1120) != 0;
    }

    boolean zzZwG() {
        return ((zzZQM)this.zzZUi().zzZbL().zzZVo()).getListId() == 0;
    }

    public TabStop[] getEffectiveTabStops() throws Exception {
        zzZQM zzZQM2 = this.zzL2(0);
        int n = zzZQM2.contains(1140) ? zzZQM2.getTabStops().getCount() : 0;
        TabStop[] tabStopArray = new TabStop[n];
        for (int i = 0; i < n; ++i) {
            tabStopArray[i] = zzZQM2.getTabStops().get(i).zzZgP();
        }
        return tabStopArray;
    }

    public int joinRunsWithSameFormatting() throws Exception {
        return this.zzS(new StringBuilder());
    }

    boolean zzZwF() throws Exception {
        return this.isListItem() && this.getListLabel().zzX5();
    }

    boolean hasRevisions() {
        return this.zzZwO().hasRevisions() || this.zzZUi().hasRevisions() || this.zzZUi().zzZxw();
    }

    boolean zzZwE() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!zzZX7.zzZQ(node)) continue;
            return true;
        }
        return false;
    }

    int zzS(StringBuilder stringBuilder) throws Exception {
        int n = 0;
        Run run = null;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() == 21) {
                Run run2 = (Run)node;
                if (run != null) {
                    zzZK7 zzZK72 = new zzZK7();
                    run.zz0B().zzZ((zzC)zzZK72, true);
                    zzZK7 zzZK73 = new zzZK7();
                    run2.zz0B().zzZ((zzC)zzZK73, true);
                    if (zzZK72.zzY((zzC)zzZK73, Run.zzYPX)) {
                        if (stringBuilder.length() == 0) {
                            zz24.zzX(stringBuilder, run.getText());
                        }
                        zz24.zzX(stringBuilder, run2.getText());
                        ++n;
                        this.removeChild(run);
                    } else {
                        Paragraph.zzZ(run, stringBuilder);
                    }
                }
                run = run2;
                continue;
            }
            Paragraph.zzZ(run, stringBuilder);
            run = null;
        }
        Paragraph.zzZ(run, stringBuilder);
        return n;
    }

    private static void zzZ(Run run, StringBuilder stringBuilder) throws Exception {
        if (run != null && stringBuilder.length() != 0) {
            run.setText(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
    }
}

