/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz1K;
import asposewobfuscated.zz3A;
import asposewobfuscated.zz3D;
import asposewobfuscated.zz3F;
import asposewobfuscated.zz80;
import asposewobfuscated.zzE9;
import asposewobfuscated.zzKT;
import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.zzDX;
import java.io.EOFException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static zz80 zzZCW = new zz80();
    private static zz80 zzZCV = new zz80();
    private static zz80 zzZCU = new zz80();
    private static zz80 zzZCT = new zz80();
    private static zz80 zzZCS = new zz80();
    private static zz80 zzZCR = new zz80();

    private FileFormatUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzE9.zzL(fileName, "fileName");
        zz3D zz3D2 = zz3F.zzWB(fileName);
        try {
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzZV(zz3D2);
            return fileFormatInfo;
        }
        finally {
            if (zz3D2 != null) {
                ((zz3A)zz3D2).close();
            }
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzZV(zz1K.zzY(stream));
    }

    static FileFormatInfo zzZV(zz3A zz3A2) throws Exception {
        if (zz3A2 == null) {
            throw new IllegalArgumentException("stream");
        }
        try {
            zzDX zzDX2 = new zzDX();
            return zzDX2.zzZX(zz3A2);
        }
        catch (Exception exception) {
            throw FileFormatUtil.zzY(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzM6(zzKT.zzZQ(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzMb(zzKT.zzZQ(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string = zzKT.zzWn(FileFormatUtil.zzM9(loadFormat));
        if (zzE9.zzZj(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzM6(FileFormatUtil.zzM8(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzMb(FileFormatUtil.zzM9(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzKT.zzWn(FileFormatUtil.zzM8(saveFormat));
        if (zzE9.zzZj(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new IllegalArgumentException("extension");
        }
        return FileFormatUtil.zzMb(zzKT.zzZP(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzKT.zzWn(FileFormatUtil.zzM7(imageType));
    }

    static Exception zzY(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ParseException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzMc(int n) {
        return zzKT.toString(FileFormatUtil.zzM8(n));
    }

    static int zzMb(int n) {
        Object object = zzZCS.get(n);
        return object == null ? 0 : (Integer)object;
    }

    static int zzMa(int n) {
        Object object = zzZCR.get(n);
        return object != null ? (Integer)object : 1;
    }

    private static int zzM9(int n) {
        Object object = zzZCW.get(n);
        return object == null ? 0 : (Integer)object;
    }

    private static int zzM8(int n) {
        Object object = zzZCV.get(n);
        return object == null ? 0 : (Integer)object;
    }

    private static int zzM7(int n) {
        Object object = zzZCU.get(n);
        return object == null ? 0 : (Integer)object;
    }

    private static int zzM6(int n) {
        Object object = zzZCT.get(n);
        return object == null ? 255 : (Integer)object;
    }

    private static void zzZ(Object ... objectArray) {
        for (int i = 0; i < objectArray.length; i += 4) {
            Object object = objectArray[i];
            Object object2 = objectArray[i + 1];
            Object object3 = objectArray[i + 2];
            Object object4 = objectArray[i + 3];
            if (object2 != null) {
                zzZCS.add((Integer)object, object2);
                zzZCV.add((Integer)object2, object);
            }
            if (object3 != null) {
                if (!zzZCT.contains((Integer)object)) {
                    zzZCT.add((Integer)object, object3);
                }
                zzZCW.add((Integer)object3, object);
            }
            if (object4 == null) continue;
            zzZCR.add((Integer)object, object4);
            zzZCU.add((Integer)object4, object);
        }
    }

    static {
        FileFormatUtil.zzZ(11, 10, 10, null, 11, null, 0, null, 12, 11, 11, null, 13, 20, 20, null, 13, null, 254, null, 14, 21, 21, null, 15, 22, 22, null, 16, 23, 23, null, 18, 24, 24, null, 19, 25, 25, null, 20, 26, 26, null, 21, 27, 27, null, 24, 30, 30, null, 17, 31, 31, null, 25, 50, 50, null, 26, 45, null, null, 27, 51, 51, null, 22, 60, 60, null, 23, 61, 61, null, 30, 40, null, null, 38, 47, null, null, 31, 41, null, null, 32, 46, null, null, 35, 42, null, null, 33, 43, null, null, 34, 44, null, null, 28, 52, null, null, 29, 70, 62, null, 36, 71, null, null, 8, 100, null, null, 6, 101, null, 6, 7, 102, null, 7, 5, 104, null, 5, 4, null, null, 4, 3, null, null, 3, 37, 72, null, null, 2, null, null, 2);
    }
}

