/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz1P;
import asposewobfuscated.zz3A;
import asposewobfuscated.zz3B;
import asposewobfuscated.zz3C;
import asposewobfuscated.zz48;
import asposewobfuscated.zz5N;
import asposewobfuscated.zzCZ;
import asposewobfuscated.zzDK;
import asposewobfuscated.zzZXT;
import com.aspose.words.Body;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.ControlChar;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Table;
import com.aspose.words.zz4X;
import com.aspose.words.zz5A;
import com.aspose.words.zz5D;
import com.aspose.words.zz5Z;
import com.aspose.words.zz6B;
import com.aspose.words.zz6T;
import com.aspose.words.zz8F;
import com.aspose.words.zz94;
import com.aspose.words.zzD1;
import com.aspose.words.zzE9;
import com.aspose.words.zzG8;
import com.aspose.words.zzH4;
import com.aspose.words.zzHZ;
import com.aspose.words.zzI6;
import com.aspose.words.zzYM;
import com.aspose.words.zzZB9;
import com.aspose.words.zzZF0;
import com.aspose.words.zzZF8;
import com.aspose.words.zzZJ2;
import com.aspose.words.zzZK7;
import com.aspose.words.zzZO3;
import com.aspose.words.zzZQM;
import com.aspose.words.zzZR;
import com.aspose.words.zzZRF;
import com.aspose.words.zzZRH;
import com.aspose.words.zzZX7;
import com.aspose.words.zzZYK;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zz5A,
zz5D,
zz6T {
    private Document zzZRN;
    private Node zzZPJ;
    private Node zzZPI;
    private zzZK7 zzZPH;
    private Font zzZPG;
    private zz48 zzZPF;
    private boolean zzZPE;
    private zzZF0 zzZPD;
    private zzYM zz4i;
    private RowFormat zzZPC;
    private CellFormat zz4h;
    private zz48 zzZPB;
    private zz48 zzZPA;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) throws Exception {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() throws Exception {
        this.zzO(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() throws Exception {
        this.zzO(-1, 1, -1, -1);
    }

    public void moveToSection(int sectionIndex) throws Exception {
        this.zzO(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) throws Exception {
        this.zzZ(this.getCurrentSection(), zzZB9.zzyk(headerFooterType), 0, 0);
    }

    private void zzO(int n, int n2, int n3, int n4) throws Exception {
        this.zzZRN.ensureMinimum();
        Section section = (Section)this.zzZRN.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Parameter name: sectionIdx");
        }
        this.zzZ(section, n2, n3, n4);
    }

    private void zzZ(Section section, int n, int n2, int n3) throws Exception {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzZB9.zzyj(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzZRN, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzZRN));
            }
        }
        this.zzZ(story, n2, n3);
    }

    private void zzZ(Story story, int n, int n2) throws Exception {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Parameter name: paraIdx");
        }
        this.zzZ(paragraph, n2);
    }

    void zzZ(Paragraph paragraph, int n) throws Exception {
        if (n == 0) {
            this.zzZ(paragraph, paragraph.getFirstChild());
        } else if (n == -1) {
            this.zzZ(paragraph, null);
        }
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName");
        }
        zzG8 zzG82 = zzZYK.zzU(this.zz9w(), fieldName);
        if (zzG82 == null) {
            return false;
        }
        return this.zzZ(zzG82, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzZ(field, isAfter, false);
    }

    private boolean zzZ(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zz6B zz6B2 = field.zz2u().zz0x();
        Inline inline = zz6B2.zzip();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzZ(inline.zz0B(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new IllegalArgumentException("bookmarkName");
        }
        Node node = isStart ? zzZR.zzZ(this.zzZRN, bookmarkName) : zzZR.zzY(this.zzZRN, bookmarkName);
        if (node == null) {
            return false;
        }
        this.zzZ((Paragraph)node.zzZER(), isAfter ? node.getNextSibling() : node);
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) throws Exception {
        this.zzZ(this.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) throws Exception {
        if (characterIndex != 0 && characterIndex != -1) {
            throw new IllegalArgumentException("Parameter name: characterIndex");
        }
        Row row = this.zzZA(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Parameter name: columnIndex");
        }
        cell.ensureMinimum();
        if (characterIndex == 0) {
            this.zzZ(cell.getFirstParagraph(), 0);
        } else if (characterIndex == -1) {
            this.zzZ(cell.getLastParagraph(), -1);
        }
    }

    void zzZ(Paragraph paragraph, Node node) throws Exception {
        if (node != null) {
            this.moveTo(node);
        } else {
            this.moveTo(paragraph);
        }
    }

    public void moveTo(Node node) throws Exception {
        if (node == null) {
            throw new IllegalArgumentException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() != 8 && !zzZX7.zzZK(node)) {
            throw new IllegalStateException("The node must be a paragraph or an inline node.");
        }
        this.zzL(node);
        if (this.getCurrentParagraph().isInCell()) {
            this.zz9F();
        } else {
            this.zzXY(false);
        }
        if (this.isAtEndOfParagraph()) {
            this.zz9G();
        } else if (!this.zz9H()) {
            this.zz9G();
        }
    }

    private boolean zz9H() throws Exception {
        Node node = this.zz9w();
        if (!(node instanceof zz5Z)) {
            while (node != null && !(node instanceof zz5Z)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zz9w(); node != null && !(node instanceof zz5Z); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            zz5Z zz5Z2 = (zz5Z)((Object)node);
            this.zzZ(zz5Z2.getRunPr_IInline(), true);
            return true;
        }
        return false;
    }

    private void zz9G() throws Exception {
        this.zzZ(this.getCurrentParagraph().zzZwO(), true);
    }

    private void zz9F() {
        Cell cell = this.getCurrentParagraph().zz36();
        Row row = cell.getParentRow();
        this.zzZPD = row.zzZAZ();
        this.zz4i = cell.zzk8();
        this.zzZPE = true;
    }

    void zzXY(boolean bl) throws Exception {
        if (!this.zzZPE) {
            return;
        }
        this.zzXX(bl);
    }

    private void zzXX(boolean bl) throws Exception {
        this.zzZPE = false;
        this.zzZPD = bl ? (zzZF0)this.zzZPD.zzmm() : zzZF0.zzZfj();
        this.zz4i = bl ? (zzYM)this.zz4i.zzmm() : new zzYM();
    }

    public Row deleteRow(int tableIndex, int rowIndex) throws Exception {
        Row row = this.zzZA(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zz9y() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zz9w().zz8(row)) {
            boolean bl;
            boolean bl2 = bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzZEP();
                this.zzZ(paragraph, 0);
            }
        }
        row.remove();
        if (!table.zzgC()) {
            table.remove();
        }
        return row;
    }

    public void write(String text) throws Exception {
        this.zzG(text, false);
    }

    public void writeln(String text) throws Exception {
        this.zzG(text, true);
    }

    public void writeln() throws Exception {
        this.insertParagraph();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Paragraph insertParagraph() throws Exception {
        Paragraph paragraph = this.getCurrentParagraph();
        try {
            this.getDocument().zza1();
            Paragraph paragraph2 = new Paragraph(this.zzZRN, this.zz9B(), this.zz9C());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzY(this.zz9w(), null, paragraph2.getLastChild());
            }
        }
        finally {
            this.getDocument().zza0();
        }
        if (this.getDocument().zz9Z()) {
            zzZO3.zzZ((zz4X)paragraph, this.getDocument().zza3());
        }
        return this.getCurrentParagraph();
    }

    public void insertBreak(int breakType) throws Exception {
        this.zzI(breakType, true);
    }

    void zzI(int n, boolean bl) throws Exception {
        switch (n) {
            case 0: {
                this.insertParagraph();
                return;
            }
            case 1: {
                if (this.zzXW(bl)) {
                    this.zzTZ(ControlChar.PAGE_BREAK);
                }
                return;
            }
            case 2: {
                if (this.zzXW(bl)) {
                    this.zzTZ(ControlChar.COLUMN_BREAK);
                }
                return;
            }
            case 4: {
                this.zzPs(1);
                return;
            }
            case 5: {
                this.zzPs(2);
                return;
            }
            case 3: {
                this.zzPs(0);
                return;
            }
            case 6: {
                this.zzPs(3);
                return;
            }
            case 7: {
                this.zzPs(4);
                return;
            }
            case 8: {
                this.zzTZ(ControlChar.LINE_BREAK);
                return;
            }
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) throws Exception {
        if (!asposewobfuscated.zzE9.zzZj(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zz1P.format("TOC {0}", switches), "");
    }

    public Field insertField(String fieldCode) throws Exception {
        Field field = this.insertField(fieldCode, null);
        field.update();
        return field;
    }

    public Field insertField(String fieldCode, String fieldValue) throws Exception {
        if (!asposewobfuscated.zzE9.zzZj(fieldCode)) {
            throw new IllegalArgumentException("fieldCode is required.");
        }
        int n = zzE9.zzRM(fieldCode);
        return this.zzY(fieldCode, fieldValue, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Field zzY(String string, String string2, int n) throws Exception {
        FieldEnd fieldEnd;
        FieldSeparator fieldSeparator;
        FieldStart fieldStart;
        try {
            this.getDocument().zza1();
            fieldStart = this.zzPr(n);
            this.zzTY(string);
            if (zzE9.zzME(n) == 2) {
                fieldSeparator = this.zzPq(n);
                if (string2 != null) {
                    this.zzTZ(string2);
                }
                fieldEnd = this.zzH(n, true);
            } else {
                fieldSeparator = null;
                fieldEnd = this.zzH(n, false);
            }
        }
        finally {
            this.getDocument().zza0();
        }
        return zzH4.zzX(fieldStart, fieldSeparator, fieldEnd);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) throws Exception {
        asposewobfuscated.zzE9.zzY(displayText, "displayText");
        asposewobfuscated.zzE9.zzY(urlOrBookmark, "hrefOrBookmark");
        zzI6 zzI62 = this.zzZ(urlOrBookmark, isBookmark, "");
        this.write(displayText);
        zzI62.zzY(this.zz9D());
        return zzH4.zzX(zzI62.getStart(), zzI62.getSeparator(), zzI62.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        if (format == null) {
            throw new IllegalArgumentException("format");
        }
        if (fieldValue == null) {
            throw new IllegalArgumentException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Parameter name: maxLength");
        }
        this.zzPr(70);
        if (asposewobfuscated.zzE9.zzZj(name)) {
            this.startBookmark(name);
        }
        this.zzTY(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzPq(70);
        String string = asposewobfuscated.zzE9.zzZj(fieldValue) ? fieldValue : FormField.zzZBj;
        Run run = new Run(this.zzZRN, string, this.zz9C());
        this.insertNode(run);
        this.zzH(70, true);
        if (asposewobfuscated.zzE9.zzZj(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzM(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        return formField;
    }

    public FormField insertCheckBox(String name, boolean defaultValue, int size) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Parameter name: size");
        }
        this.zzPr(71);
        if (asposewobfuscated.zzE9.zzZj(name)) {
            this.startBookmark(name);
        }
        this.zzTY(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzH(71, false);
        if (asposewobfuscated.zzE9.zzZj(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzM(fieldEnd);
        formField.setName(name);
        formField.setChecked(defaultValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        if (items == null) {
            throw new IllegalArgumentException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Parameter name: selectedIndex");
        }
        this.zzPr(83);
        if (asposewobfuscated.zzE9.zzZj(name)) {
            this.startBookmark(name);
        }
        this.zzTY(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzH(83, false);
        if (asposewobfuscated.zzE9.zzZj(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzM(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) throws Exception {
        boolean bl = footnoteType == 0;
        Footnote footnote = new Footnote((DocumentBase)this.zzZRN, footnoteType);
        footnote.getFont().setStyleIdentifier(bl ? 38 : 42);
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzZRN);
        paragraph.getParagraphFormat().setStyleIdentifier(bl ? 29 : 43);
        footnote.getParagraphs().add(paragraph);
        SpecialChar specialChar = new SpecialChar(this.zzZRN, '\u0002', new zzZK7());
        specialChar.getFont().setStyleIdentifier(bl ? 38 : 42);
        paragraph.appendChild(specialChar);
        if (asposewobfuscated.zzE9.zzZj(footnoteText)) {
            Node node = this.zz9w();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzL(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    Shape zz3(zz3A zz3A2) throws Exception {
        return this.zzZ(zz3A2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zz3(zz3A.zzZ(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    Shape zzZ(zz3A zz3A2, double d, double d2) throws Exception {
        return this.zzZ(zz3A2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzZ(zz3A.zzZ(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new IllegalArgumentException("image");
        }
        zz3C zz3C2 = new zz3C();
        try {
            zzDK.zzY(image, zz3C2);
            Shape shape = this.zzZ(zz3C2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (zz3C2 != null) {
                zz3C2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        asposewobfuscated.zzE9.zzL(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzCZ.zzYB(fileName);
        try {
            Shape shape = this.zzZ((zz3A)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zz3A)object).close();
            }
        }
    }

    Shape zzZ(zz3A zz3A2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zz3A2 == null) {
            throw new IllegalArgumentException("stream");
        }
        byte[] byArray = asposewobfuscated.zzE9.zzt(zz3A2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzZ(zz3A.zzZ(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (imageBytes == null) {
            throw new IllegalArgumentException("imageBytes");
        }
        Shape shape = new Shape(this.zzZRN, 75);
        shape.zzU(this.zz9C());
        shape.getImageData().setImageBytes(imageBytes);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzA(width < 0.0 ? imageSize.getWidthPoints() : width, height < 0.0 ? imageSize.getHeightPoints() : height);
        return shape;
    }

    Shape zzZ(zz3A zz3A2, String string, boolean bl, BufferedImage bufferedImage) throws Exception {
        zzZRH zzZRH2 = zzZRH.zzLh(string);
        if (bufferedImage == null) {
            bufferedImage = zzZRF.zzZ(zzZRH2, bl);
        }
        Shape shape = this.insertImage(bufferedImage);
        shape.zzNx(-2);
        shape.getOleFormat().setProgId(zzZRH2.zzZ47);
        shape.getOleFormat().zzZ(zzZRF.zzZ(zz3A2, string, bl));
        return shape;
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, BufferedImage presentation) throws Exception {
        return this.zzZ(zz3A.zzZ(stream), progId, asIcon, presentation);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, BufferedImage presentation) throws Exception {
        zzZRH zzZRH2 = zzZRH.zzLg(zz3B.zzWy(fileName));
        if (presentation == null) {
            presentation = zzZRF.zzZ(zzZRH2, asIcon);
        }
        Shape shape = this.insertImage(presentation);
        shape.zzNx(-2);
        shape.getOleFormat().setProgId(zzZRH2.zzZ47);
        shape.getOleFormat().zzZ(zzZRF.zzU(fileName, isLinked, asIcon));
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.zzZ(html, null);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        zz94 zz942 = new zz94();
        zz942.zzX0(useBuilderFormatting);
        zz942.zzWZ(useBuilderFormatting);
        this.zzZ(html, zz942);
    }

    void zzZ(String string, zz94 zz942) throws Exception {
        if (this.zz9E()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(string);
            this.write(DocumentBuilder.zzU0(documentBuilder.getDocument().toString(70)));
        } else {
            zz8F zz8F2 = new zz8F(50, this.getDocument().getResourceLoadingCallback());
            if (zz942 == null) {
                zz942 = new zz94();
            }
            zz8F2.zzZ(string, this, zz942);
        }
    }

    private boolean zz9E() {
        boolean bl = false;
        if (this.zz9w().getParentNode().getNodeType() == 29) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zz9w().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzU0(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() throws Exception {
        if (this.zz9y() == null) {
            this.startTable();
        }
        if (this.zz9y().zzZgq() == 1) {
            this.zz9y().zzZgt();
        }
        if (this.zz9y().zzZgq() == 3) {
            this.zz9y().zzZgr();
        }
        return this.zz9y().zzZgs();
    }

    public Table startTable() throws Exception {
        this.zzZPA.push(this.zz9A());
        this.zzZPB.push(new zzZF8(this));
        return this.zz9y().startTable();
    }

    public Table endTable() throws Exception {
        if (this.zz9y() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zz9y().endTable();
        this.zzZPB.pop();
        this.zzZPD = (zzZF0)this.zzZPA.pop();
        return table;
    }

    public Row endRow() throws Exception {
        if (this.zz9y() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        return this.zz9y().endRow();
    }

    public BookmarkStart startBookmark(String bookmarkName) throws Exception {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzZRN, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) throws Exception {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzZRN, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public Document getDocument() {
        return this.zzZRN;
    }

    public void setDocument(Document value) throws Exception {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (value == this.zzZRN) {
            return;
        }
        this.zzZRN = value;
        this.zzL(null);
        this.zzZPH = new zzZK7();
        this.zzZPF = null;
        this.zzZPG = null;
        this.zzXX(false);
        this.zzZPB = new zz48();
        this.zzZPA = new zz48();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzZPG == null) {
            this.zzZPG = new Font(this, this.getDocument());
        }
        return this.zzZPG;
    }

    public boolean getBold() throws Exception {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) throws Exception {
        this.getFont().setBold(value);
    }

    public boolean getItalic() throws Exception {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) throws Exception {
        this.getFont().setItalic(value);
    }

    public int getUnderline() throws Exception {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) throws Exception {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzZPC == null) {
            this.zzZPC = new RowFormat(this);
        }
        return this.zzZPC;
    }

    public CellFormat getCellFormat() {
        if (this.zz4h == null) {
            this.zz4h = new CellFormat(this);
        }
        return this.zz4h;
    }

    void zzN(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() throws Exception {
        this.zz9x().push(this.zz9C());
    }

    public void popFont() throws Exception {
        if (this.zz9x().getCount() > 0) {
            this.zzZ((zzZK7)this.zz9x().pop(), false);
        }
    }

    zzI6 zzZ(String string, boolean bl, String string2) throws Exception {
        FieldStart fieldStart = this.zzPr(88);
        zzHZ zzHZ2 = new zzHZ();
        zzHZ2.setTarget(string2);
        if (bl) {
            zzHZ2.zzSh(string);
        } else {
            zzHZ2.zzSi(zz5N.zzXp(string));
            zzHZ2.zzSh(zz5N.zzXo(string));
        }
        this.zzTY(zzHZ2.toString());
        FieldSeparator fieldSeparator = this.zzPq(88);
        return new zzI6(fieldStart, fieldSeparator, null);
    }

    zzI6 zzZZ(String string, String string2) throws Exception {
        boolean bl = zz5N.zzXg(string);
        String string3 = bl ? zz5N.zzXo(string) : string;
        return this.zzZ(string3, bl, string2);
    }

    FieldEnd zz9D() throws Exception {
        return this.zzH(88, true);
    }

    zzZK7 zz9C() throws Exception {
        return (zzZK7)this.zzZPH.zzmm();
    }

    zzZQM zz9B() throws Exception {
        return (zzZQM)this.getCurrentParagraph().zzZUi().zzmm();
    }

    zzZF0 zz9A() throws Exception {
        return (zzZF0)this.zzZPD.zzmm();
    }

    zzYM zz9z() throws Exception {
        return (zzYM)this.zz4i.zzmm();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zz9w(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zz9w().getNodeType() == 8;
    }

    private void zzG(String string, boolean bl) throws Exception {
        if (string == null) {
            throw new IllegalArgumentException("text");
        }
        String string2 = zzZB9.zzHN(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    this.zzTZ(string2.substring(n, n + n2));
                }
                this.insertParagraph();
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                this.zzTZ(string2.substring(n, n + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            break;
        }
    }

    private Run zzTZ(String string) throws Exception {
        Run run = new Run(this.zzZRN, string, this.zz9C());
        this.insertNode(run);
        return run;
    }

    public void insertNode(Node node) throws Exception {
        if (this.zz9y() != null && this.zz9y().zzZgq() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
        } else {
            this.zz9w().getParentNode().insertBefore(node, this.zz9w());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzPs(int n) throws Exception {
        this.zzXW(true);
        this.insertParagraph();
        try {
            this.getDocument().zza1();
            zzZJ2 zzZJ22 = (zzZJ2)this.getCurrentSection().zzZBu().zzmm();
            Section section = new Section(this.zzZRN, zzZJ22);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzZRN));
            this.zzZRN.insertAfter(section, this.getCurrentSection());
            section.getBody().zzY(this.getCurrentParagraph(), null, section.getBody().getLastChild());
        }
        finally {
            this.getDocument().zza0();
        }
    }

    private FieldStart zzPr(int n) throws Exception {
        FieldStart fieldStart = new FieldStart((DocumentBase)this.zzZRN, this.zz9C(), n);
        this.insertNode(fieldStart);
        return fieldStart;
    }

    private Run zzTY(String string) throws Exception {
        Run run = this.zzTZ(string);
        return run;
    }

    private FieldEnd zzH(int n, boolean bl) throws Exception {
        FieldEnd fieldEnd = new FieldEnd((DocumentBase)this.zzZRN, this.zz9C(), n, bl);
        this.insertNode(fieldEnd);
        return fieldEnd;
    }

    private FieldSeparator zzPq(int n) throws Exception {
        FieldSeparator fieldSeparator = new FieldSeparator((DocumentBase)this.zzZRN, this.zz9C(), n);
        this.insertNode(fieldSeparator);
        return fieldSeparator;
    }

    private FormField zzM(Node node) throws Exception {
        FormField formField = new FormField((DocumentBase)this.zzZRN, new zzD1(), this.zz9C());
        this.getCurrentParagraph().insertBefore(formField, node);
        return formField;
    }

    private boolean zzXW(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zz9y() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzZA(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Parameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Parameter name: rowIndex");
        }
        return row;
    }

    void zzZ(zzZK7 zzZK72, boolean bl) throws Exception {
        this.zzZPH = bl ? (zzZK7)zzZK72.zzmm() : zzZK72;
    }

    public Node getCurrentNode() {
        return this.isAtEndOfParagraph() ? null : this.zz9w();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zz9w();
        }
        return (Paragraph)this.zz9w().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzZF8 zz9y() {
        return this.zzZPB.getCount() > 0 ? zzZXT.zzZ(this.zzZPB.peek(), zzZF8.class) : null;
    }

    private zz48 zz9x() {
        if (this.zzZPF == null) {
            this.zzZPF = new zz48();
        }
        return this.zzZPF;
    }

    @Override
    @ReservedForInternalUse
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzZPH.zzS0(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    public int getDirectRunAttrsCount() {
        return this.zzZPH.getCount();
    }

    @Override
    @ReservedForInternalUse
    public void getDirectRunAttrByIndex(int index, int[] key, Object[] value) {
        key[0] = this.zzZPH.zzTQ(index);
        value[0] = this.zzZPH.zzVY(index);
    }

    @Override
    @ReservedForInternalUse
    public Object fetchInheritedRunAttr(int fontAttr) throws Exception {
        Object object = this.getFont().getStyle().zzZV(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzZV(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    public void setRunAttr(int fontAttr, Object value) {
        this.zzZPH.zzW(fontAttr, value);
        if (this.getCurrentParagraph() != null && !this.getCurrentParagraph().hasChildNodes()) {
            this.getCurrentParagraph().zzZwO().zzW(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    public void removeRunAttr(int key) {
        this.zzZPH.remove(key);
    }

    @Override
    @ReservedForInternalUse
    public void clearRunAttrs() {
        this.zzZPH.zzmo();
    }

    @Override
    @ReservedForInternalUse
    public Object getDirectRowAttr(int key) {
        return this.zzZPD.zzS0(key);
    }

    @Override
    @ReservedForInternalUse
    public Object fetchInheritedRowAttr(int key) {
        return this.zzZPD.zzRY(key);
    }

    @Override
    @ReservedForInternalUse
    public void setRowAttr(int key, Object value) {
        this.zzZPD.zzW(key, value);
    }

    @Override
    @ReservedForInternalUse
    public void clearRowAttrs() {
        this.zzZPD.clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    public void resetToDefaultAttrs() {
        this.zzZPD = zzZF0.zzZfj();
    }

    @Override
    @ReservedForInternalUse
    public Object getDirectCellAttr(int key) {
        return this.zz4i.zzS0(key);
    }

    @Override
    @ReservedForInternalUse
    public Object fetchInheritedCellAttr(int key) {
        return this.zz4i.zzRY(key);
    }

    @Override
    @ReservedForInternalUse
    public void setCellAttr(int key, Object value) {
        this.zz4i.zzW(key, value);
    }

    @Override
    @ReservedForInternalUse
    public void clearCellAttrs() {
        this.zz4i.zzmo();
    }

    private Node zz9w() {
        if (this.zzZPJ != null && this.zzZPJ.getParentNode() == null) {
            return this.zzZPI;
        }
        return this.zzZPJ;
    }

    private void zzL(Node node) {
        this.zzZPJ = node;
        if (this.zzZPJ != null) {
            this.zzZPI = this.zzZPJ.getParentNode();
        }
    }
}

