/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.internal.p0;

import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.FileNotFoundException;
import com.aspose.slides.exceptions.IOException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.exceptions.ObjectDisposedException;
import com.aspose.slides.internal.p0.j2;
import com.aspose.slides.internal.p0.q2;
import com.aspose.slides.internal.p0.vr;
import com.aspose.slides.internal.xg.wr;
import com.aspose.slides.ms.System.mh;
import com.aspose.slides.ms.System.p2;
import com.aspose.slides.ms.System.s0;
import java.io.File;

public class io
extends vr {
    private boolean fx = false;
    private boolean jz;
    private boolean ny;
    private boolean wr;
    private wr y4;
    private final String k5;

    public io(String string, int n) {
        this(string, n, n == 6 ? 2 : 3);
    }

    private io(int n, String string, int n10, int n11) {
        String string2;
        if (n != -2 && n <= 0) {
            throw new ArgumentOutOfRangeException("bufferSize", "Positive number required.");
        }
        boolean bl2 = n > 0;
        this.k5 = string;
        if (string == null) {
            throw new ArgumentNullException("path", "Path cannot be null.");
        }
        if (p2.jz(string).length() == 0) {
            throw new ArgumentException("Empty path name is not legal.");
        }
        if (n10 < 1 || n10 > 6) {
            throw new ArgumentOutOfRangeException("mode", "Enum value was out of legal range.");
        }
        if (n11 < 1 || n11 > 3) {
            throw new ArgumentOutOfRangeException("access", "Enum value was out of legal range.");
        }
        if (n11 == 1) {
            this.ny = false;
            this.jz = true;
            string2 = "r";
        } else if (n11 == 2) {
            this.ny = true;
            this.jz = false;
            string2 = "rw";
        } else {
            this.ny = true;
            this.jz = true;
            string2 = "rw";
        }
        File file = new File(string);
        if (n10 == 6) {
            if (n11 == 3) {
                throw new ArgumentException("Append access can be requested only in write-only mode.");
            }
            if (n11 == 1) {
                throw new ArgumentException(p2.fx("Combining FileMode: {0} with FileAccess: {1} is invalid.", new Object[]{mh.getName(j2.class, n10), mh.getName(q2.class, n11)}));
            }
        }
        if ((n10 == 2 || n10 == 1 || n10 == 5) && n11 == 1) {
            throw new ArgumentException(p2.fx("Combining FileMode: {0} with FileAccess: {1} is invalid.", new Object[]{mh.getName(j2.class, n10), mh.getName(q2.class, n11)}));
        }
        if (file.exists()) {
            if (n10 == 1) {
                throw new IOException("Can't create new file. File '" + string + "' already exist.");
            }
            if (n10 == 2 || n10 == 5) {
                file.delete();
            }
            this.y4 = bl2 ? new wr(file, string2, n) : new wr(file, string2);
            if (n10 == 6) {
                this.y4.fx(this.y4.wr());
            }
        } else {
            if (n10 == 3 || n10 == 5) {
                throw new FileNotFoundException("Can't find file: " + string + ".", string);
            }
            if (bl2) {
                this.y4 = new wr(file, string2, n);
            } else if (string2.equals("r") && n10 == 4) {
                string2 = "rw";
                this.y4 = new wr(file, string2);
                this.y4.fx(true);
            } else {
                this.y4 = new wr(file, string2);
            }
        }
        this.wr = true;
    }

    public io(String string, int n, int n10) {
        this(-2, string, n, n10);
    }

    public io(String string, int n, int n10, int n11) {
        this(string, n, n10);
    }

    public io(String string, int n, int n10, int n11, int n12) {
        this(n12, string, n, n10);
    }

    @Override
    public boolean canRead() {
        return this.jz;
    }

    @Override
    public boolean canSeek() {
        return this.wr;
    }

    @Override
    public boolean canWrite() {
        return this.ny;
    }

    @Override
    public long getLength() {
        if (this.fx) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        return this.y4.wr();
    }

    @Override
    public long getPosition() {
        if (this.fx) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        return this.y4.ny();
    }

    @Override
    public void setPosition(long position) {
        if (position < 0L) {
            throw new ArgumentOutOfRangeException("value", "Non-negative number required.");
        }
        if (this.fx) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        this.y4.fx(position);
    }

    @Override
    public void flush() {
        if (this.fx) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        this.y4.y4();
    }

    @Override
    public long seek(long offset, int origin) {
        if (origin < 0 || origin > 2) {
            throw new ArgumentException("Invalid seek origin.");
        }
        if (this.fx) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        switch (origin) {
            case 0: {
                this.y4.fx(offset);
                break;
            }
            case 1: {
                this.y4.fx(this.y4.ny() + offset);
                break;
            }
            case 2: {
                this.y4.fx(this.y4.wr() + offset);
            }
        }
        return this.y4.ny();
    }

    @Override
    protected void dispose(boolean disposing) {
        try {
            if (this.y4 != null && !this.y4.jz()) {
                this.y4.fx();
            }
        }
        finally {
            this.jz = false;
            this.ny = false;
            this.wr = false;
            super.dispose(disposing);
            this.fx = true;
        }
    }

    @Override
    public void setLength(long length) {
        if (length < 0L) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (length == Long.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("length", "file length too big");
        }
        if (this.fx) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        if (!this.ny) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.y4.ny(length);
    }

    @Override
    public int read(byte[] buffer, int offset, int count) {
        if (buffer == null) {
            throw new ArgumentNullException("array", "Buffer cannot be null.");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "Non-negative number required.");
        }
        if (buffer.length - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.fx) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (this.jz) {
            int n = this.y4.jz(buffer, offset, count);
            return n == -1 ? 0 : n;
        }
        throw new NotSupportedException("Stream does not support reading.");
    }

    @Override
    public int readByte() {
        if (this.fx) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (this.jz) {
            return this.y4.k5();
        }
        throw new NotSupportedException("Stream does not support reading.");
    }

    @Override
    public void write(byte[] array, int offset, int count) {
        if (array == null) {
            throw new ArgumentNullException("array", "Buffer cannot be null.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "Non-negative number required.");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (array.length - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.fx) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.ny) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.y4.write(array, offset, count);
    }

    @Override
    public void writeByte(byte value) {
        if (this.fx) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.ny) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.y4.write(value);
    }

    public String fx() {
        return this.k5;
    }

    @Override
    public s0 beginRead(byte[] buffer, int offset, int count, com.aspose.slides.ms.System.q2 callback, Object state) {
        if (buffer == null) {
            throw new ArgumentNullException("buffer");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("numBytes", "Non-negative number required.");
        }
        if (buffer.length - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.fx) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        return super.beginRead(buffer, offset, count, callback, state);
    }

    @Override
    public int endRead(s0 asyncResult) {
        if (asyncResult == null) {
            throw new ArgumentNullException("asyncResult");
        }
        return super.endRead(asyncResult);
    }

    @Override
    public s0 beginWrite(byte[] array, int offset, int numBytes, com.aspose.slides.ms.System.q2 userCallback, Object stateObject) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (numBytes < 0) {
            throw new ArgumentOutOfRangeException("numBytes", "Non-negative number required.");
        }
        if (array.length - offset < numBytes) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.fx) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        return super.beginWrite(array, offset, numBytes, userCallback, stateObject);
    }

    @Override
    public void endWrite(s0 asyncResult) {
        if (asyncResult == null) {
            throw new ArgumentNullException("asyncResult");
        }
        super.endWrite(asyncResult);
    }
}

