/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.KeyValuePair;
import com.aspose.slides.IOutputFile;
import com.aspose.slides.Input;
import com.aspose.slides.Output;
import com.aspose.slides.Storage;
import com.aspose.slides.WebDocumentOptions;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.internal.p6.ny;
import com.aspose.slides.ms.System.IDisposable;

public class WebDocument {
    private final WebDocumentOptions fx;
    private final Input jz;
    private final Output ny;
    private final Storage wr = new Storage();

    public WebDocument(WebDocumentOptions options) {
        if (options == null) {
            throw new ArgumentNullException("options");
        }
        if (options.getTemplateEngine() == null) {
            throw new ArgumentException("TemplateEngine should not be null", "options");
        }
        if (options.getOutputSaver() == null) {
            throw new ArgumentException("OutputSaver should not be null", "options");
        }
        this.fx = options;
        this.jz = new Input(this.fx.getTemplateEngine());
        this.ny = new Output(this.fx.getTemplateEngine(), this.wr);
    }

    public final void save() {
        IGenericEnumerator iGenericEnumerator = this.ny.fx().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                KeyValuePair keyValuePair = (KeyValuePair)iGenericEnumerator.next();
                this.fx.getOutputSaver().save((String)keyValuePair.getKey(), (IOutputFile)keyValuePair.getValue());
            }
        }
        finally {
            if (com.aspose.slides.internal.p6.ny.fx(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    public final Input getInput() {
        return this.jz;
    }

    public final Output getOutput() {
        return this.ny;
    }

    public final Storage getGlobal() {
        return this.wr;
    }
}

