/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Cell;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.Collections.Generic.SortedDictionary;
import com.aspose.slides.GroupShape;
import com.aspose.slides.IAutoShape;
import com.aspose.slides.IBaseSlide;
import com.aspose.slides.IChart;
import com.aspose.slides.IFindResultCallback;
import com.aspose.slides.IGroupShape;
import com.aspose.slides.IParagraph;
import com.aspose.slides.IPresentation;
import com.aspose.slides.IShape;
import com.aspose.slides.IShapeCollection;
import com.aspose.slides.ISlide;
import com.aspose.slides.ISlideComponent;
import com.aspose.slides.ISmartArt;
import com.aspose.slides.ISmartArtNode;
import com.aspose.slides.ITable;
import com.aspose.slides.ITextFrame;
import com.aspose.slides.ITextSearchOptions;
import com.aspose.slides.PortionFormat;
import com.aspose.slides.Presentation;
import com.aspose.slides.Row;
import com.aspose.slides.TextFrame;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.internal.j7.wq;
import com.aspose.slides.internal.p6.ny;
import com.aspose.slides.internal.t7.rb;
import com.aspose.slides.lzh;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.p2;
import com.aspose.slides.yqg;
import com.aspose.slides.zhu;

public class SlideUtil {
    public static IShape findShape(IPresentation pres, String altText) {
        IShape iShape;
        int n;
        for (n = 0; n < pres.getMasters().size(); ++n) {
            iShape = SlideUtil.findShape(pres.getMasters().get_Item(n), altText);
            if (iShape == null) continue;
            return iShape;
        }
        for (n = 0; n < pres.getSlides().size(); ++n) {
            iShape = SlideUtil.findShape(pres.getSlides().get_Item(n), altText);
            if (iShape == null) continue;
            return iShape;
        }
        return null;
    }

    public static IShape findShape(IBaseSlide slide, String altText) {
        return SlideUtil.fx(slide.getShapes(), altText);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IBaseSlide slide) {
        int[] nArray = new int[slide.getShapes().size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        SlideUtil.fx(alignmentType, alignToSlide, slide.getShapes(), nArray);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IBaseSlide slide, int[] shapeIndexes) {
        SlideUtil.fx(alignmentType, alignToSlide, slide.getShapes(), shapeIndexes);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IGroupShape groupShape) {
        int[] nArray = new int[groupShape.getShapes().size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        SlideUtil.fx(alignmentType, alignToSlide, groupShape.getShapes(), nArray);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IGroupShape groupShape, int[] shapeIndexes) {
        SlideUtil.fx(alignmentType, alignToSlide, groupShape.getShapes(), shapeIndexes);
    }

    public static void findAndReplaceText(IPresentation presentation, boolean withMasters, String find, String replace) {
        SlideUtil.findAndReplaceText(presentation, withMasters, find, replace, null);
    }

    public static void findAndReplaceText(IPresentation presentation, boolean withMasters, String find, String replace, PortionFormat format) {
        if (presentation == null) {
            throw new ArgumentNullException("presentation");
        }
        if (p2.fx(find)) {
            throw new ArgumentException("String to find can not be null or empty", "find");
        }
        if (replace == null) {
            throw new ArgumentNullException("replace");
        }
        if (p2.y4(find, replace)) {
            throw new ArgumentException("String to find can not be equal to string to find");
        }
        for (ITextFrame iTextFrame : SlideUtil.getAllTextFrames(presentation, withMasters)) {
            SlideUtil.fx(iTextFrame, find, replace, format);
            iTextFrame.joinPortionsWithSameFormatting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fx(ITextFrame iTextFrame, String string, String string2, PortionFormat portionFormat) {
        IGenericEnumerator iGenericEnumerator = iTextFrame.getParagraphs().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IParagraph iParagraph = (IParagraph)iGenericEnumerator.next();
                SlideUtil.fx(iParagraph, string, string2, portionFormat);
            }
        }
        finally {
            if (ny.fx(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    private static void fx(IParagraph iParagraph, String string, String string2, PortionFormat portionFormat) {
        if (p2.y4(string, string2)) {
            return;
        }
        yqg yqg2 = yqg.fx(iParagraph);
        while (yqg2.fx(string, string2, portionFormat)) {
        }
        iParagraph.getPortions().clear();
        yqg2.jz(iParagraph);
    }

    public static ITextFrame[] getAllTextBoxes(IBaseSlide slide) {
        List<ITextFrame> list = new List<ITextFrame>();
        SlideUtil.fx(slide.getShapes(), list);
        return list.toArray((ITextFrame[])new ITextFrame[0]);
    }

    public static ITextFrame[] getAllTextFrames(IPresentation pres, boolean withMasters) {
        int n;
        List<ITextFrame> list = new List<ITextFrame>();
        if (withMasters) {
            for (n = 0; n < pres.getMasters().size(); ++n) {
                SlideUtil.fx(pres.getMasters().get_Item(n).getShapes(), list);
            }
        }
        for (n = 0; n < pres.getSlides().size(); ++n) {
            SlideUtil.fx(pres.getSlides().get_Item(n).getShapes(), list);
        }
        return list.toArray(new ITextFrame[0]);
    }

    static ITextFrame[] fx(IPresentation iPresentation, int[] nArray, boolean bl2) {
        List<ITextFrame> list = new List<ITextFrame>();
        for (int n : nArray) {
            SlideUtil.fx(iPresentation.getSlides().get_Item(n - 1).getShapes(), list);
            if (!bl2) continue;
            SlideUtil.fx(iPresentation.getSlides().get_Item(n - 1).getLayoutSlide().getShapes(), list);
            SlideUtil.fx(iPresentation.getSlides().get_Item(n - 1).getLayoutSlide().getMasterSlide().getShapes(), list);
        }
        return list.toArray(new ITextFrame[0]);
    }

    static String fx(IPresentation iPresentation, int[] nArray) {
        wq wq2 = new wq();
        for (int n : nArray) {
            ITextFrame[] iTextFrameArray;
            ISlide iSlide = iPresentation.getSlides().get_Item(n - 1);
            for (ITextFrame iTextFrame : iTextFrameArray = SlideUtil.getAllTextBoxes(iSlide)) {
                wq2.fx(iTextFrame.getText());
            }
        }
        return wq2.toString();
    }

    private static void fx(int n, boolean bl2, IShapeCollection iShapeCollection, int[] nArray) {
        int n10;
        if (nArray == null) {
            throw new ArgumentNullException("shapeIndexes");
        }
        if (nArray.length == 0) {
            throw new ArgumentException("Indexes of shapes to be aligned should not be empty", "shapeIndexes");
        }
        SortedDictionary<Integer, Integer> sortedDictionary = new SortedDictionary<Integer, Integer>();
        int[] objectArray = nArray;
        int list = objectArray.length;
        for (n10 = 0; n10 < list; ++n10) {
            int n11 = objectArray[n10];
            if (n11 < 0) {
                throw new ArgumentException("Indexes of shapes to be aligned should be positive", "shapeIndexes");
            }
            if (sortedDictionary.containsKey(n11)) continue;
            sortedDictionary.addItem(n11, n11);
        }
        Integer[] integerArray = new Integer[sortedDictionary.size()];
        ((SortedDictionary.KeyCollection)sortedDictionary.getKeys()).copyTo(integerArray, 0);
        if (integerArray[integerArray.length - 1] > iShapeCollection.size() - 1) {
            throw new ArgumentException("Indexes of shapes to be aligned should correspond to slide shape indexes", "shapeIndexes");
        }
        List<IShape> list2 = new List<IShape>(((SortedDictionary.KeyCollection)sortedDictionary.getKeys()).size());
        for (n10 = 0; n10 < ((SortedDictionary.KeyCollection)sortedDictionary.getKeys()).size(); ++n10) {
            list2.addItem(iShapeCollection.get_Item(nArray[n10]));
        }
        zhu.fx(n, bl2, list2);
    }

    private static IShape fx(IShapeCollection iShapeCollection, String string) {
        for (int i = 0; i < iShapeCollection.size(); ++i) {
            IShape iShape;
            IShape iShape2 = iShapeCollection.get_Item(i);
            if (p2.k5(iShape2.getAlternativeText(), string) == 0) {
                return iShape2;
            }
            if (!ny.jz((Object)iShape2, GroupShape.class) || (iShape = SlideUtil.fx(((GroupShape)iShape2).getShapes(), string)) == null) continue;
            return iShape;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fx(IShapeCollection iShapeCollection, List<ITextFrame> list) {
        for (int i = 0; i < iShapeCollection.size(); ++i) {
            Object object;
            ISlideComponent iSlideComponent;
            if (ny.jz((Object)iShapeCollection.get_Item(i), IGroupShape.class)) {
                SlideUtil.fx(((IGroupShape)iShapeCollection.get_Item(i)).getShapes(), list);
                continue;
            }
            IAutoShape iAutoShape = (IAutoShape)((Object)ny.fx(iShapeCollection.get_Item(i), IAutoShape.class));
            if (iAutoShape != null) {
                iSlideComponent = iAutoShape.getTextFrame();
                if (iSlideComponent == null) continue;
                list.addItem((ITextFrame)iSlideComponent);
                continue;
            }
            iSlideComponent = (ITable)((Object)ny.fx(iShapeCollection.get_Item(i), ITable.class));
            if (iSlideComponent != null) {
                for (int j = 0; j < iSlideComponent.getRows().size(); ++j) {
                    for (int k = 0; k < iSlideComponent.getColumns().size(); ++k) {
                        object = ((Row)iSlideComponent.getRows().get_Item(j)).fx(k);
                        if (((Cell)object).getTextFrame() == null) continue;
                        list.addItem(((Cell)object).getTextFrame());
                    }
                }
                continue;
            }
            IChart iChart = (IChart)((Object)ny.fx(iShapeCollection.get_Item(i), IChart.class));
            if (iChart != null && iChart.getUserShapes() != null) {
                SlideUtil.fx(iChart.getUserShapes().getShapes(), list);
                continue;
            }
            ISmartArt iSmartArt = (ISmartArt)((Object)ny.fx(iShapeCollection.get_Item(i), ISmartArt.class));
            if (iSmartArt == null) continue;
            object = iSmartArt.getAllNodes();
            IGenericEnumerator iGenericEnumerator = object.iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    ISmartArtNode iSmartArtNode = (ISmartArtNode)iGenericEnumerator.next();
                    list.addItem(iSmartArtNode.getTextFrame());
                }
                continue;
            }
            finally {
                if (ny.fx(iGenericEnumerator, IDisposable.class) != false) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
        }
    }

    private static lzh fx(Presentation presentation, String string, ITextSearchOptions iTextSearchOptions, IFindResultCallback iFindResultCallback) {
        if (p2.fx(string)) {
            throw new ArgumentException("Text to highlight can not be null or empty", "text");
        }
        int n = 0;
        if (iTextSearchOptions != null && !iTextSearchOptions.getCaseSensitive()) {
            n |= 0x42;
        }
        rb rb2 = new rb("\\-\\[\\]\\{\\}\\(\\)\\*\\+\\?\\.\\,\\\\\\^\\$\\|#\\s");
        String string2 = rb2.ny(string, "\\$0");
        if (iTextSearchOptions != null && iTextSearchOptions.getWholeWordsOnly()) {
            string2 = p2.fx(new String[]{"\\b", string2, "\\b"});
        }
        rb rb3 = new rb(string2, n);
        return SlideUtil.jz(presentation, rb3, iFindResultCallback);
    }

    private static lzh fx(Presentation presentation, rb rb2, IFindResultCallback iFindResultCallback) {
        if (rb2 == null) {
            throw new ArgumentException("Regex to highlight can not be null", "regex");
        }
        return SlideUtil.jz(presentation, rb2, iFindResultCallback);
    }

    private static lzh jz(Presentation presentation, rb rb2, IFindResultCallback iFindResultCallback) {
        lzh lzh2 = new lzh(rb2);
        for (ITextFrame iTextFrame : SlideUtil.getAllTextFrames(presentation, false)) {
            TextFrame textFrame = (TextFrame)iTextFrame;
            textFrame.fx(rb2, iFindResultCallback);
            if (textFrame.ny.y4() <= 0) continue;
            lzh2.fx(textFrame);
        }
        return lzh2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fx(Presentation presentation, String string, com.aspose.slides.internal.nw.rb rb2, ITextSearchOptions iTextSearchOptions, IFindResultCallback iFindResultCallback) {
        lzh lzh2 = SlideUtil.fx(presentation, string, iTextSearchOptions, iFindResultCallback);
        IGenericEnumerator iGenericEnumerator = lzh2.jz().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TextFrame textFrame = (TextFrame)iGenericEnumerator.next();
                textFrame.fx(lzh2.fx(), rb2.to());
            }
        }
        finally {
            if (ny.fx(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fx(Presentation presentation, rb rb2, com.aspose.slides.internal.nw.rb rb3, IFindResultCallback iFindResultCallback) {
        lzh lzh2 = SlideUtil.fx(presentation, rb2, iFindResultCallback);
        IGenericEnumerator iGenericEnumerator = lzh2.jz().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TextFrame textFrame = (TextFrame)iGenericEnumerator.next();
                textFrame.fx(lzh2.fx(), rb3.to());
            }
        }
        finally {
            if (ny.fx(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fx(Presentation presentation, String string, String string2, ITextSearchOptions iTextSearchOptions, IFindResultCallback iFindResultCallback) {
        lzh lzh2 = SlideUtil.fx(presentation, string, iTextSearchOptions, iFindResultCallback);
        IGenericEnumerator iGenericEnumerator = lzh2.jz().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TextFrame textFrame = (TextFrame)iGenericEnumerator.next();
                textFrame.fx(lzh2.fx(), string2);
            }
        }
        finally {
            if (ny.fx(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fx(Presentation presentation, rb rb2, String string, IFindResultCallback iFindResultCallback) {
        lzh lzh2 = SlideUtil.fx(presentation, rb2, iFindResultCallback);
        IGenericEnumerator iGenericEnumerator = lzh2.jz().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TextFrame textFrame = (TextFrame)iGenericEnumerator.next();
                textFrame.fx(lzh2.fx(), string);
            }
        }
        finally {
            if (ny.fx(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }
}

