/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.a2;
import com.aspose.slides.ms.System.tt;
import com.aspose.slides.ms.System.wr;
import com.aspose.slides.ms.System.wt;
import java.util.Arrays;

@tt
public class Stack
implements ICollection,
IEnumerable,
wt {
    private Object[] fx;
    private int jz = -1;
    private int ny;
    private int wr;
    private int y4;

    private void fx(int n) {
        n = Math.max(n, 16);
        Object[] objectArray = new Object[n];
        com.aspose.slides.ms.System.wr.fx(this.fx, 0, objectArray, 0, this.ny);
        this.wr = n;
        this.fx = objectArray;
    }

    public Stack() {
        this.fx = new Object[16];
        this.wr = 16;
    }

    public Stack(ICollection col) {
        this(col == null ? 16 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.push(e);
        }
    }

    public Stack(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new ArgumentOutOfRangeException("initialCapacity");
        }
        this.wr = initialCapacity;
        this.fx = new Object[this.wr];
    }

    public static Stack sync(Stack stack) {
        if (stack == null) {
            throw new ArgumentNullException("stack");
        }
        return new SyncStack(stack);
    }

    @Override
    public int size() {
        return this.ny;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    public void clear() {
        ++this.y4;
        for (int i = 0; i < this.ny; ++i) {
            this.fx[i] = null;
        }
        this.ny = 0;
        this.jz = -1;
    }

    @Override
    public Object deepClone() {
        Stack stack = new Stack(com.aspose.slides.ms.System.wr.fx(this.fx));
        stack.jz = this.jz;
        stack.ny = this.ny;
        return stack;
    }

    public boolean contains(Object obj) {
        if (this.ny == 0) {
            return false;
        }
        if (obj == null) {
            for (int i = 0; i < this.ny; ++i) {
                if (this.fx[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.ny; ++i) {
                if (!obj.equals(this.fx[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void copyTo(wr array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.wr() > 1 || array.y4() > 0 && index >= array.y4() || this.ny > array.y4() - index) {
            throw new ArgumentException();
        }
        for (int i = this.jz; i != -1; --i) {
            array.ny(this.fx[i], this.ny - (i + 1) + index);
        }
    }

    public IEnumerator iterator() {
        return new Enumerator(this);
    }

    public Object peek() {
        if (this.jz == -1) {
            throw new InvalidOperationException();
        }
        return this.fx[this.jz];
    }

    public Object pop() {
        if (this.jz == -1) {
            throw new InvalidOperationException();
        }
        ++this.y4;
        Object object = this.fx[this.jz];
        this.fx[this.jz] = null;
        --this.ny;
        --this.jz;
        if (this.ny <= this.wr / 4 && this.ny > 16) {
            this.fx(this.wr / 2);
        }
        return object;
    }

    public void push(Object obj) {
        ++this.y4;
        if (this.wr == this.ny) {
            this.fx(this.wr * 2);
        }
        ++this.ny;
        ++this.jz;
        this.fx[this.jz] = obj;
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.ny) {
            a = Arrays.copyOf(this.fx, this.ny, a.getClass());
            a2.fx(a);
            return a;
        }
        System.arraycopy(this.fx, 0, a, 0, this.ny);
        if (a.length > this.ny) {
            a[this.ny] = null;
        }
        a2.fx(a);
        return a;
    }

    private static class Enumerator
    implements IEnumerator,
    wt,
    Cloneable {
        private Stack fx;
        private int jz;
        private int ny;

        Enumerator(Stack s) {
            this.fx = s;
            this.jz = s.y4;
            this.ny = -2;
        }

        private Enumerator() {
        }

        @Override
        public Object deepClone() {
            return this.fx();
        }

        @Override
        public Object next() {
            if (this.jz != this.fx.y4 || this.ny == -2 || this.ny == -1 || this.ny > this.fx.ny) {
                throw new InvalidOperationException();
            }
            return this.fx.fx[this.ny];
        }

        @Override
        public boolean hasNext() {
            if (this.jz != this.fx.y4) {
                throw new InvalidOperationException();
            }
            switch (this.ny) {
                case -2: {
                    this.ny = this.fx.jz;
                    return this.ny != -1;
                }
                case -1: {
                    return false;
                }
            }
            --this.ny;
            return this.ny != -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.jz != this.fx.y4) {
                throw new InvalidOperationException();
            }
            this.ny = -2;
        }

        protected Object fx() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            Enumerator enumerator = new Enumerator();
            enumerator.fx = this.fx;
            enumerator.jz = this.jz;
            enumerator.ny = this.ny;
            return enumerator;
        }
    }

    @tt
    private static class SyncStack
    extends Stack {
        private final Stack fx;

        SyncStack(Stack s) {
            this.fx = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Stack stack = this.fx;
            synchronized (stack) {
                return this.fx.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.fx.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Stack stack = this.fx;
            synchronized (stack) {
                this.fx.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Stack stack = this.fx;
            synchronized (stack) {
                return Stack.sync((Stack)this.fx.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Stack stack = this.fx;
            synchronized (stack) {
                return this.fx.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(wr array, int index) {
            Stack stack = this.fx;
            synchronized (stack) {
                this.fx.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Stack stack = this.fx;
            synchronized (stack) {
                return new Enumerator(this.fx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Stack stack = this.fx;
            synchronized (stack) {
                return this.fx.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object pop() {
            Stack stack = this.fx;
            synchronized (stack) {
                return this.fx.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void push(Object obj) {
            Stack stack = this.fx;
            synchronized (stack) {
                this.fx.push(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Stack stack = this.fx;
            synchronized (stack) {
                return this.fx.toArray(a);
            }
        }
    }
}

