/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Specialized;

import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.internal.j7.wq;
import com.aspose.slides.internal.p6.ny;
import com.aspose.slides.internal.p6.q2;
import com.aspose.slides.ms.System.h1;
import com.aspose.slides.ms.System.z3;

public class BitVector32
extends q2<BitVector32> {
    private int fx;

    public BitVector32() {
    }

    public BitVector32(BitVector32 value) {
        this.fx = value.fx;
    }

    public BitVector32(int data) {
        this.fx = data;
    }

    public int getData() {
        return this.fx;
    }

    public int get_Item(Section section) {
        return this.fx >> section.getOffset() & section.getMask();
    }

    public void set_Item(Section section, int value) {
        if (value < 0) {
            throw new ArgumentException("Section can't hold negative values");
        }
        if (value > section.getMask()) {
            throw new ArgumentException("Value too large to fit in section");
        }
        this.fx &= ~(section.getMask() << section.getOffset());
        this.fx |= value << section.getOffset();
    }

    public boolean get_Item(int bit) {
        return (this.fx & bit) == bit;
    }

    public void set_Item(int bit, boolean value) {
        this.fx = value ? (this.fx |= bit) : (this.fx &= ~bit);
    }

    public static int createMask() {
        return 1;
    }

    public static int createMask(int previous) {
        if (previous == 0) {
            return 1;
        }
        if (previous == Integer.MIN_VALUE) {
            throw new InvalidOperationException("all bits set");
        }
        return previous << 1;
    }

    public static Section createSection(short maxValue) {
        return BitVector32.createSection(maxValue, new Section(0, 0));
    }

    public static Section createSection(short maxValue, Section previous) {
        if (maxValue < 1) {
            throw new ArgumentException("maxValue");
        }
        int n = BitVector32.fx(maxValue);
        int n10 = (1 << n) - 1;
        int n11 = previous.getOffset() + BitVector32.fx(previous.getMask());
        if (n11 + n > 32) {
            throw new ArgumentException("Sections cannot exceed 32 bits in total");
        }
        return new Section(ny.jz((Object)n10, 9), ny.jz((Object)n11, 9));
    }

    public boolean equals(Object o) {
        return ny.jz(o, BitVector32.class) && this.fx == ny.wr((Object)o, BitVector32.class).fx;
    }

    public int hashCode() {
        return h1.fx(this.fx);
    }

    public String toString() {
        return BitVector32.toString(this.Clone());
    }

    public static String toString(BitVector32 value) {
        wq wq2 = new wq();
        wq2.fx("BitVector32{");
        for (long i = ny.k5((Object)0x80000000L, 10); i > 0L; i >>= 1) {
            wq2.fx(((long)value.fx & i) == 0L ? (char)'0' : '1');
        }
        wq2.fx('}');
        return wq2.toString();
    }

    private static int fx(int n) {
        int n10 = 0;
        while (n >> n10 != 0) {
            ++n10;
        }
        return n10;
    }

    @Override
    public void CloneTo(BitVector32 that) {
        that.fx = this.fx;
    }

    @Override
    public BitVector32 Clone() {
        BitVector32 bitVector32 = new BitVector32();
        this.CloneTo(bitVector32);
        return bitVector32;
    }

    public Object clone() {
        return this.Clone();
    }

    public static boolean equals(BitVector32 obj1, BitVector32 obj2) {
        return obj1.equals(obj2);
    }

    public static class Section
    extends q2<Section> {
        private short fx;
        private short jz;

        public Section() {
        }

        Section(short mask, short offset) {
            this.fx = mask;
            this.jz = offset;
        }

        public short getMask() {
            return this.fx;
        }

        public short getOffset() {
            return this.jz;
        }

        public static boolean op_Equality(Section a, Section b) {
            return a.fx == b.fx && a.jz == b.jz;
        }

        public static boolean op_Inequality(Section a, Section b) {
            return a.fx != b.fx || a.jz != b.jz;
        }

        public boolean equals(Section obj) {
            return this.fx == obj.fx && this.jz == obj.jz;
        }

        public boolean equals(Object o) {
            if (!ny.jz(o, Section.class)) {
                return false;
            }
            Section section = ny.wr(o, Section.class).Clone();
            return this.fx == section.fx && this.jz == section.jz;
        }

        public int hashCode() {
            return this.fx << this.jz;
        }

        public String toString() {
            return Section.toString(this.Clone());
        }

        public static String toString(Section value) {
            wq wq2 = new wq();
            wq2.fx("Section{0x");
            wq2.fx(z3.fx(value.getMask(), 16));
            wq2.fx(", 0x");
            wq2.fx(z3.fx(value.getOffset(), 16));
            wq2.fx("}");
            return wq2.toString();
        }

        @Override
        public void CloneTo(Section that) {
            that.fx = this.fx;
            that.jz = this.jz;
        }

        @Override
        public Section Clone() {
            Section section = new Section();
            this.CloneTo(section);
            return section;
        }

        public Object clone() {
            return this.Clone();
        }

        public static boolean equals(Section obj1, Section obj2) {
            return obj1.equals(obj2);
        }
    }
}

