/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.internal.p6.q2;
import com.aspose.slides.ms.System.mh;
import com.aspose.slides.ms.System.p2;
import com.aspose.slides.ms.System.q7;
import com.aspose.slides.ms.System.tt;
import com.aspose.slides.ms.System.wr;
import com.aspose.slides.ms.System.wt;
import java.util.Comparator;

@tt
public class SortedList
implements IDictionary,
wt {
    private final Object fx = new Object();
    private Slot[] jz;
    private Comparator ny;
    private int wr;
    private int y4;
    private int k5;

    public SortedList() {
        this(null, 16);
    }

    public SortedList(int initialCapacity) {
        this(null, initialCapacity);
    }

    public SortedList(Comparator comparer, int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.k5 = capacity == 0 ? 0 : 16;
        this.ny = comparer;
        this.jz(capacity, true);
    }

    public SortedList(Comparator comparer) {
        this.ny = comparer;
        this.jz(16, true);
    }

    public SortedList(IDictionary d) {
        this(d, null);
    }

    public SortedList(IDictionary d, Comparator comparer) {
        if (d == null) {
            throw new ArgumentNullException("dictionary");
        }
        this.jz(d.size(), true);
        this.ny = comparer;
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Override
    public int size() {
        return this.wr;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this.fx;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ICollection getKeys() {
        return new ListKeys(this);
    }

    @Override
    public ICollection getValues() {
        return new ListValues(this);
    }

    @Override
    public Object get_Item(Object key) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        return this.fx(key);
    }

    @Override
    public void set_Item(Object key, Object value) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        if (this.isReadOnly()) {
            throw new NotSupportedException("SortedList is Read Only.");
        }
        if (this.jz(key) < 0 && this.isFixedSize()) {
            throw new NotSupportedException("Key not found and SortedList is fixed size.");
        }
        this.fx(key, value, true);
    }

    public int getCapacity() {
        return this.jz.length;
    }

    public void setCapacity(int value) {
        int n = this.jz.length;
        if (this.wr > value) {
            throw new ArgumentOutOfRangeException("capacity too small");
        }
        if (value == 0) {
            Slot[] slotArray = SortedList.fx(this.k5);
            SortedList.fx(this.jz, 0, slotArray, 0, this.wr);
            this.jz = slotArray;
        } else if (value > this.wr) {
            Slot[] slotArray = SortedList.fx(value);
            SortedList.fx(this.jz, 0, slotArray, 0, this.wr);
            this.jz = slotArray;
        } else if (value > n) {
            Slot[] slotArray = SortedList.fx(value);
            SortedList.fx(this.jz, 0, slotArray, 0, n);
            this.jz = slotArray;
        }
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new Enumerator(this, 2);
    }

    @Deprecated
    public IDictionaryEnumerator iteratorJava() {
        return new EnumeratorJava(this, 2);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.fx(key, value, false);
    }

    @Override
    public void clear() {
        this.k5 = 16;
        this.jz = SortedList.fx(this.k5);
        this.wr = 0;
        ++this.y4;
    }

    @Override
    public boolean contains(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.jz(key) >= 0;
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void removeItem(Object key) {
        int n = this.indexOfKey(key);
        if (n >= 0) {
            this.removeAt(n);
        }
    }

    @Override
    public void copyTo(wr array, int arrayIndex) {
        if (null == array) {
            throw new ArgumentNullException();
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (array.wr() > 1) {
            throw new ArgumentException("array is multi-dimensional");
        }
        if (arrayIndex >= array.y4()) {
            throw new ArgumentNullException("arrayIndex is greater than or equal to array.Length");
        }
        if (this.size() > array.y4() - arrayIndex) {
            throw new ArgumentNullException("Not enough space in array from arrayIndex to end of array");
        }
        IDictionaryEnumerator iDictionaryEnumerator = this.iterator();
        int n = arrayIndex;
        while (iDictionaryEnumerator.hasNext()) {
            array.ny(iDictionaryEnumerator.getEntry().Clone(), n++);
        }
    }

    @Override
    public Object deepClone() {
        SortedList sortedList = new SortedList(this, this.ny);
        sortedList.y4 = this.y4;
        return sortedList;
    }

    public IList getKeyList() {
        return new ListKeys(this);
    }

    public IList getValueList() {
        return new ListValues(this);
    }

    public void removeAt(int index) {
        Slot[] slotArray = this.jz;
        int n = this.size();
        if (index >= 0 && index < n) {
            if (index != n - 1) {
                SortedList.fx(slotArray, index + 1, slotArray, index, n - 1 - index);
            } else {
                slotArray[index].fx = null;
                slotArray[index].jz = null;
            }
            --this.wr;
            ++this.y4;
        } else {
            throw new ArgumentOutOfRangeException("index out of range");
        }
    }

    public int indexOfKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        int n = 0;
        try {
            n = this.jz(key);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        return n | n >> 31;
    }

    public int indexOfValue(Object value) {
        if (this.wr == 0) {
            return -1;
        }
        for (int i = 0; i < this.wr; ++i) {
            Slot slot = this.jz[i].Clone();
            if (!q7.fx(value, slot.jz)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.contains(key);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    public boolean containsValue(Object value) {
        return this.indexOfValue(value) >= 0;
    }

    public Object getByIndex(int index) {
        if (index >= 0 && index < this.size()) {
            return this.jz[index].jz;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public void setByIndex(int index, Object value) {
        if (index < 0 || index >= this.size()) {
            throw new ArgumentOutOfRangeException("index out of range");
        }
        this.jz[index].jz = value;
    }

    public Object getKey(int index) {
        if (index >= 0 && index < this.size()) {
            return this.jz[index].fx;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public static SortedList sync(SortedList list) {
        if (list == null) {
            throw new ArgumentNullException("Base list is null.");
        }
        return new SynchedSortedList(list);
    }

    public void trimToSize() {
        if (this.size() == 0) {
            this.fx(this.k5, false);
        } else {
            this.fx(this.size(), true);
        }
    }

    private void fx(int n, boolean bl2) {
        Slot[] slotArray = this.jz;
        Slot[] slotArray2 = SortedList.fx(n);
        if (bl2) {
            SortedList.fx(slotArray, 0, slotArray2, 0, n);
        }
        this.jz = slotArray2;
    }

    private void fx(int n, int n10) {
        boolean bl2;
        Slot[] slotArray = this.jz;
        Slot[] slotArray2 = null;
        int n11 = this.getCapacity();
        boolean bl3 = bl2 = n10 >= 0 && n10 < this.size();
        if (n > n11) {
            slotArray2 = SortedList.fx(n << 1);
        }
        if (slotArray2 != null) {
            if (bl2) {
                int n12 = n10;
                if (n12 > 0) {
                    SortedList.fx(slotArray, 0, slotArray2, 0, n12);
                }
                if ((n12 = this.size() - n10) > 0) {
                    SortedList.fx(slotArray, n10, slotArray2, n10 + 1, n12);
                }
            } else {
                SortedList.fx(slotArray, 0, slotArray2, 0, this.size());
            }
            this.jz = slotArray2;
        } else if (bl2) {
            SortedList.fx(slotArray, n10, slotArray, n10 + 1, this.size() - n10);
        }
    }

    private void fx(Object object, Object object2, boolean bl2) {
        if (object == null) {
            throw new ArgumentNullException("null key");
        }
        Slot[] slotArray = this.jz;
        int n = -1;
        try {
            n = this.jz(object);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        if (n >= 0) {
            if (!bl2) {
                String string = p2.fx("Key '{0}' already exists in list.", new Object[]{object});
                throw new ArgumentException(string);
            }
            slotArray[n].jz = object2;
            ++this.y4;
            return;
        }
        if ((n ^= 0xFFFFFFFF) > this.getCapacity() + 1) {
            throw new RuntimeException(p2.fx(new Object[]{"SortedList::internal error (", object, ", ", object2, ") at [", n, "]"}));
        }
        this.fx(this.size() + 1, n);
        slotArray = this.jz;
        slotArray[n].fx = object;
        slotArray[n].jz = object2;
        ++this.wr;
        ++this.y4;
    }

    private Object fx(Object object) {
        int n = this.jz(object);
        if (n >= 0) {
            return this.jz[n].jz;
        }
        return null;
    }

    private void jz(int n, boolean bl2) {
        if (!bl2 && n < this.k5) {
            n = this.k5;
        }
        this.jz = SortedList.fx(n);
        this.wr = 0;
        this.y4 = 0;
    }

    private void fx(wr wr2, int n, int n10) {
        if (wr2 == null) {
            throw new ArgumentNullException("arr");
        }
        if (n < 0 || n + this.size() > wr2.y4()) {
            throw new ArgumentOutOfRangeException("i");
        }
        Enumerator enumerator = new Enumerator(this, n10);
        while (enumerator.hasNext()) {
            wr2.ny(enumerator.next(), n++);
        }
    }

    private int jz(Object object) {
        Slot[] slotArray = this.jz;
        int n = this.size();
        if (n == 0) {
            return -1;
        }
        Comparator comparator = this.ny == null ? Comparer.Default : this.ny;
        int n10 = 0;
        int n11 = n - 1;
        while (n10 <= n11) {
            int n12 = n10 + n11 >> 1;
            int n13 = comparator.compare(slotArray[n12].fx, object);
            if (n13 == 0) {
                return n12;
            }
            if (n13 < 0) {
                n10 = n12 + 1;
                continue;
            }
            n11 = n12 - 1;
        }
        return ~n10;
    }

    static Slot[] fx(int n) {
        Slot[] slotArray = new Slot[n];
        for (int i = 0; i < n; ++i) {
            slotArray[i] = new Slot();
        }
        return slotArray;
    }

    private static boolean fx(int n, int n10, int n11) {
        return n < n10 && n + n11 > n10 || n10 < n && n10 + n11 > n;
    }

    static void fx(Slot[] slotArray, int n, Slot[] slotArray2, int n10, int n11) {
        Slot[] slotArray3;
        if (slotArray == slotArray2 && SortedList.fx(n, n10, n11)) {
            slotArray3 = new Slot[n11];
            System.arraycopy(slotArray, n, slotArray3, 0, n11);
            n = 0;
        } else {
            slotArray3 = slotArray;
        }
        for (int i = 0; i < n11; ++i) {
            slotArray2[n10 + i] = slotArray3[n + i].Clone();
        }
    }

    private static class SynchedSortedList
    extends SortedList {
        private SortedList fx;

        public SynchedSortedList(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.fx = host;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                return this.fx.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                this.fx.setCapacity(value);
            }
        }

        @Override
        public int size() {
            return this.fx.size();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.fx.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.fx.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.fx.isReadOnly();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            ICollection iCollection = null;
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                iCollection = this.fx.getKeys();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            ICollection iCollection = null;
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                iCollection = this.fx.getValues();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(Object key) {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                return this.fx.fx(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                this.fx.fx(key, value, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(wr array, int arrayIndex) {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                this.fx.copyTo(array, arrayIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                this.fx.fx(key, value, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                this.fx.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object key) {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                return this.fx.jz(key) >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IDictionaryEnumerator iterator() {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                return this.fx.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public IDictionaryEnumerator iteratorJava() {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                return this.fx.iteratorJava();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                this.fx.removeItem(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                return this.fx.contains(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                return this.fx.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                return this.fx.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getByIndex(int index) {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                return this.fx.getByIndex(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getKey(int index) {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                return this.fx.getKey(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getKeyList() {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                return new ListKeys(this.fx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getValueList() {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                return new ListValues(this.fx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                this.fx.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfKey(Object key) {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                return this.fx.indexOfKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfValue(Object val) {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                return this.fx.indexOfValue(val);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setByIndex(int index, Object value) {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                this.fx.setByIndex(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                this.fx.trimToSize();
            }
        }
    }

    @tt
    private static class ListValues
    implements IList {
        private SortedList fx;

        public ListValues(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.fx = host;
        }

        @Override
        public int size() {
            return this.fx.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.fx.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.fx.getSyncRoot();
        }

        @Override
        public void copyTo(wr array, int arrayIndex) {
            this.fx.fx(array, arrayIndex, 1);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.fx.getByIndex(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("This operation is not supported on GetValueList return");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object value) {
            return this.fx.containsValue(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.fx.indexOfValue(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.fx, 1);
        }
    }

    @tt
    private static class ListKeys
    implements IList {
        private SortedList fx;

        public ListKeys(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.fx = host;
        }

        @Override
        public int size() {
            return this.fx.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.fx.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.fx.getSyncRoot();
        }

        @Override
        public void copyTo(wr array, int arrayIndex) {
            this.fx.fx(array, arrayIndex, 0);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.fx.getKey(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("attempt to modify a key");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object key) {
            return this.fx.contains(key);
        }

        @Override
        public int indexOf(Object key) {
            return this.fx.indexOfKey(key);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.fx, 0);
        }
    }

    @Deprecated
    private static final class EnumeratorJava
    implements IDictionaryEnumerator,
    wt {
        private SortedList fx;
        private Object jz;
        private Object ny;
        private int wr;
        private int y4;
        private int k5;
        private int q2;
        private boolean rb = false;
        private static String yv = "SortedList.EnumeratorJava: snapshot out of sync.";

        public EnumeratorJava(SortedList host, int mode) {
            this.fx = host;
            this.wr = host.y4;
            this.k5 = host.size();
            this.q2 = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.fx.y4 != this.wr || this.rb) {
                throw new IllegalStateException(yv);
            }
            this.y4 = -1;
            this.jz = null;
            this.ny = null;
        }

        @Override
        public boolean hasNext() {
            if (this.fx.y4 != this.wr || this.rb) {
                throw new InvalidOperationException(yv);
            }
            return ++this.y4 < this.k5;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.rb || this.y4 >= this.k5 || this.y4 == -1) {
                throw new IllegalStateException(yv);
            }
            return new DictionaryEntry(this.jz, this.ny);
        }

        @Override
        public Object getKey() {
            if (this.rb || this.y4 >= this.k5 || this.y4 == -1) {
                throw new IllegalStateException(yv);
            }
            return this.jz;
        }

        @Override
        public Object getValue() {
            if (this.rb || this.y4 >= this.k5 || this.y4 == -1) {
                throw new IllegalStateException(yv);
            }
            return this.ny;
        }

        @Override
        public Object next() {
            if (this.fx.y4 != this.wr || this.rb) {
                throw new InvalidOperationException(yv);
            }
            if (this.rb || this.y4 >= this.k5 || this.y4 == -1) {
                if (this.y4 >= this.k5) {
                    this.jz = null;
                    this.ny = null;
                }
                throw new IllegalStateException(yv);
            }
            Slot[] slotArray = this.fx.jz;
            Slot slot = slotArray[this.y4].Clone();
            this.jz = slot.fx;
            this.ny = slot.jz;
            switch (this.q2) {
                case 0: {
                    return this.jz;
                }
                case 1: {
                    return this.ny;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(p2.fx(new String[]{mh.getName(EnumeratorMode.class, this.q2), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            EnumeratorJava enumeratorJava = new EnumeratorJava(this.fx, this.q2);
            enumeratorJava.wr = this.wr;
            enumeratorJava.y4 = this.y4;
            enumeratorJava.k5 = this.k5;
            enumeratorJava.jz = this.jz;
            enumeratorJava.ny = this.ny;
            enumeratorJava.rb = this.rb;
            return enumeratorJava;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class Enumerator
    implements IDictionaryEnumerator,
    wt {
        private SortedList fx;
        private Object jz;
        private Object ny;
        private int wr;
        private int y4;
        private int k5;
        private int q2;
        private boolean rb = false;
        private static String yv = "SortedList.Enumerator: snapshot out of sync.";

        public Enumerator(SortedList host, int mode) {
            this.fx = host;
            this.wr = host.y4;
            this.k5 = host.size();
            this.q2 = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.fx.y4 != this.wr || this.rb) {
                throw new IllegalStateException(yv);
            }
            this.y4 = -1;
            this.jz = null;
            this.ny = null;
        }

        @Override
        public boolean hasNext() {
            if (this.fx.y4 != this.wr || this.rb) {
                throw new InvalidOperationException(yv);
            }
            Slot[] slotArray = this.fx.jz;
            if (++this.y4 < this.k5) {
                Slot slot = slotArray[this.y4].Clone();
                this.jz = slot.fx;
                this.ny = slot.jz;
                return true;
            }
            this.jz = null;
            this.ny = null;
            return false;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.rb || this.y4 >= this.k5 || this.y4 == -1) {
                throw new IllegalStateException(yv);
            }
            return new DictionaryEntry(this.jz, this.ny);
        }

        @Override
        public Object getKey() {
            if (this.rb || this.y4 >= this.k5 || this.y4 == -1) {
                throw new IllegalStateException(yv);
            }
            return this.jz;
        }

        @Override
        public Object getValue() {
            if (this.rb || this.y4 >= this.k5 || this.y4 == -1) {
                throw new IllegalStateException(yv);
            }
            return this.ny;
        }

        @Override
        public Object next() {
            if (this.rb || this.y4 >= this.k5 || this.y4 == -1) {
                throw new IllegalStateException(yv);
            }
            switch (this.q2) {
                case 0: {
                    return this.jz;
                }
                case 1: {
                    return this.ny;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(p2.fx(new String[]{mh.getName(EnumeratorMode.class, this.q2), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            Enumerator enumerator = new Enumerator(this.fx, this.q2);
            enumerator.wr = this.wr;
            enumerator.y4 = this.y4;
            enumerator.k5 = this.k5;
            enumerator.jz = this.jz;
            enumerator.ny = this.ny;
            enumerator.rb = this.rb;
            return enumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class EnumeratorMode
    extends mh {
        private EnumeratorMode() {
        }

        static {
            mh.register(new mh.y4(EnumeratorMode.class, Integer.class){
                {
                    this.addConstant("KEY_MODE", 0L);
                    this.addConstant("VALUE_MODE", 1L);
                    this.addConstant("ENTRY_MODE", 2L);
                }
            });
        }
    }

    @tt
    public static class Slot
    extends q2<Slot> {
        Object fx;
        Object jz;

        @Override
        public void CloneTo(Slot that) {
            that.fx = this.fx;
            that.jz = this.jz;
        }

        @Override
        public Slot Clone() {
            Slot slot = new Slot();
            this.CloneTo(slot);
            return slot;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean fx(Slot slot) {
            return q7.fx(slot.fx, this.fx) && q7.fx(slot.jz, this.jz);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (q7.jz(null, obj)) {
                return false;
            }
            if (q7.jz(this, obj)) {
                return true;
            }
            if (!(obj instanceof Slot)) {
                return false;
            }
            return this.fx((Slot)obj);
        }

        public static boolean equals(Slot obj1, Slot obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.fx != null ? this.fx.hashCode() : 0;
            n = 31 * n + (this.jz != null ? this.jz.hashCode() : 0);
            return n;
        }
    }
}

