/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.tt;
import com.aspose.slides.ms.System.wr;
import com.aspose.slides.ms.System.wt;
import java.util.Arrays;

@tt
public class Queue
implements ICollection,
IEnumerable,
wt {
    private Object[] fx;
    private int jz = 0;
    private int ny = 0;
    private int wr = 0;
    private int y4;
    private int k5 = 0;

    public Queue() {
        this(32, 2.0f);
    }

    public Queue(int capacity) {
        this(capacity, 2.0f);
    }

    public Queue(ICollection col) {
        this(col == null ? 32 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.enqueue(e);
        }
    }

    public Queue(int capacity, float growFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Needs a non-negative number");
        }
        if (!(growFactor >= 1.0f) || !(growFactor <= 10.0f)) {
            throw new ArgumentOutOfRangeException("growFactor", "Queue growth factor must be between 1.0 and 10.0, inclusive");
        }
        this.fx = new Object[capacity];
        this.y4 = (int)(growFactor * 100.0f);
    }

    @Override
    public int size() {
        return this.ny;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(wr array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.wr() > 1 || index != 0 && index >= array.y4() || this.ny > array.y4() - index) {
            throw new ArgumentException();
        }
        int n = this.fx.length;
        int n10 = n - this.jz;
        com.aspose.slides.ms.System.wr.fx(com.aspose.slides.ms.System.wr.fx(this.fx), this.jz, array, index, Math.min(this.ny, n10));
        if (this.ny > n10) {
            com.aspose.slides.ms.System.wr.fx(com.aspose.slides.ms.System.wr.fx(this.fx), 0, array, index + n10, this.ny - n10);
        }
    }

    public IEnumerator iterator() {
        return new QueueEnumerator(this);
    }

    @Override
    public Object deepClone() {
        Queue queue = new Queue(this.fx.length);
        queue.y4 = this.y4;
        com.aspose.slides.ms.System.wr.fx(this.fx, 0, queue.fx, 0, this.fx.length);
        queue.jz = this.jz;
        queue.ny = this.ny;
        queue.wr = this.wr;
        return queue;
    }

    public void clear() {
        ++this.k5;
        this.jz = 0;
        this.ny = 0;
        this.wr = 0;
        for (int i = this.fx.length - 1; i >= 0; --i) {
            this.fx[i] = null;
        }
    }

    public boolean contains(Object obj) {
        int n = this.jz + this.ny;
        if (obj == null) {
            for (int i = this.jz; i < n; ++i) {
                if (this.fx[i % this.fx.length] != null) continue;
                return true;
            }
        } else {
            for (int i = this.jz; i < n; ++i) {
                if (!obj.equals(this.fx[i % this.fx.length])) continue;
                return true;
            }
        }
        return false;
    }

    public Object dequeue() {
        ++this.k5;
        if (this.ny < 1) {
            throw new InvalidOperationException();
        }
        Object object = this.fx[this.jz];
        this.fx[this.jz] = null;
        this.jz = (this.jz + 1) % this.fx.length;
        --this.ny;
        return object;
    }

    public void enqueue(Object obj) {
        ++this.k5;
        if (this.ny == this.fx.length) {
            this.fx();
        }
        this.fx[this.wr] = obj;
        this.wr = (this.wr + 1) % this.fx.length;
        ++this.ny;
    }

    public Object peek() {
        if (this.ny < 1) {
            throw new InvalidOperationException();
        }
        return this.fx[this.jz];
    }

    public static Queue sync(Queue queue) {
        if (queue == null) {
            throw new ArgumentNullException("queue");
        }
        return new SyncQueue(queue);
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.ny) {
            return Arrays.copyOf(this.fx, this.ny, a.getClass());
        }
        System.arraycopy(this.fx, 0, a, 0, this.ny);
        if (a.length > this.ny) {
            a[this.ny] = null;
        }
        return a;
    }

    public void trimToSize() {
        ++this.k5;
        Object[] objectArray = new Object[this.ny];
        this.copyTo(com.aspose.slides.ms.System.wr.fx(objectArray), 0);
        this.fx = objectArray;
        this.jz = 0;
        this.wr = 0;
    }

    private void fx() {
        int n = this.fx.length * this.y4 / 100;
        if (n < this.fx.length + 1) {
            n = this.fx.length + 1;
        }
        Object[] objectArray = new Object[n];
        this.copyTo(com.aspose.slides.ms.System.wr.fx(objectArray), 0);
        this.fx = objectArray;
        this.jz = 0;
        this.wr = this.jz + this.ny;
    }

    @tt
    private static class QueueEnumerator
    implements IEnumerator,
    wt {
        private Queue fx;
        private int jz;
        private int ny;

        QueueEnumerator(Queue q) {
            this.fx = q;
            this.jz = q.k5;
            this.ny = -1;
        }

        @Override
        public Object deepClone() {
            QueueEnumerator queueEnumerator = new QueueEnumerator(this.fx);
            queueEnumerator.jz = this.jz;
            queueEnumerator.ny = this.ny;
            return queueEnumerator;
        }

        @Override
        public Object next() {
            if (this.jz != this.fx.k5 || this.ny < 0 || this.ny >= this.fx.ny) {
                throw new InvalidOperationException();
            }
            return this.fx.fx[(this.fx.jz + this.ny) % this.fx.fx.length];
        }

        @Override
        public boolean hasNext() {
            if (this.jz != this.fx.k5) {
                throw new InvalidOperationException();
            }
            if (this.ny >= this.fx.ny - 1) {
                this.ny = Integer.MAX_VALUE;
                return false;
            }
            ++this.ny;
            return true;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.jz != this.fx.k5) {
                throw new InvalidOperationException();
            }
            this.ny = -1;
        }
    }

    private static class SyncQueue
    extends Queue {
        private final Queue fx;

        SyncQueue(Queue queue) {
            this.fx = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Queue queue = this.fx;
            synchronized (queue) {
                return this.fx.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.fx.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(wr array, int index) {
            Queue queue = this.fx;
            synchronized (queue) {
                this.fx.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Queue queue = this.fx;
            synchronized (queue) {
                return this.fx.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Queue queue = this.fx;
            synchronized (queue) {
                return new SyncQueue((Queue)this.fx.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Queue queue = this.fx;
            synchronized (queue) {
                this.fx.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Queue queue = this.fx;
            synchronized (queue) {
                this.fx.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Queue queue = this.fx;
            synchronized (queue) {
                return this.fx.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object dequeue() {
            Queue queue = this.fx;
            synchronized (queue) {
                return this.fx.dequeue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enqueue(Object obj) {
            Queue queue = this.fx;
            synchronized (queue) {
                this.fx.enqueue(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Queue queue = this.fx;
            synchronized (queue) {
                return this.fx.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Queue queue = this.fx;
            synchronized (queue) {
                return this.fx.toArray(a);
            }
        }
    }
}

