/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.ObjectModel;

import com.aspose.slides.Collections.Generic.Dictionary;
import com.aspose.slides.Collections.Generic.EqualityComparer;
import com.aspose.slides.Collections.Generic.IGenericDictionary;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.IGenericEqualityComparer;
import com.aspose.slides.Collections.ObjectModel.Collection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.KeyNotFoundException;
import com.aspose.slides.ms.System.tt;

@tt
public abstract class KeyedCollection<TKey, TItem>
extends Collection<TItem> {
    private Dictionary<TKey, TItem> fx;
    private IGenericEqualityComparer<TKey> jz;
    private int ny;

    protected KeyedCollection() {
        this(null, 0);
    }

    protected KeyedCollection(IGenericEqualityComparer<TKey> comparer) {
        this(comparer, 0);
    }

    protected KeyedCollection(IGenericEqualityComparer<TKey> comparer, int dictionaryCreationThreshold) {
        this.jz = comparer != null ? comparer : new EqualityComparer.DefaultComparer<TKey>();
        this.ny = dictionaryCreationThreshold;
        if (dictionaryCreationThreshold == 0) {
            this.fx = new Dictionary(this.jz);
        }
    }

    public boolean containsKey(TKey key) {
        if (this.fx != null) {
            return this.fx.containsKey(key);
        }
        return this.fx(key) >= 0;
    }

    private int fx(TKey TKey) {
        for (int i = this.size() - 1; i >= 0; --i) {
            TKey TKey2 = this.getKeyForItem(super.get_Item(i));
            if (!this.jz.equalsT(TKey, TKey2)) continue;
            return i;
        }
        return -1;
    }

    public boolean removeByKey(TKey key) {
        Object object = null;
        if (this.fx != null) {
            Object[] objectArray = new Object[]{object};
            boolean bl2 = this.fx.tryGetValue(key, objectArray);
            object = objectArray[0];
            if (bl2) {
                return super.removeItem(object);
            }
            return false;
        }
        int n = this.fx(key);
        if (n == -1) {
            return false;
        }
        this.removeAt(n);
        return true;
    }

    public IGenericEqualityComparer<TKey> getComparer() {
        return this.jz;
    }

    @Override
    public TItem get_Item(int index) {
        if (this.fx != null && ((Dictionary.KeyCollection)this.fx.getKeys()).size() > 0) {
            IGenericEnumerator iGenericEnumerator = ((Dictionary.KeyCollection)this.fx.getKeys()).iterator();
            if (iGenericEnumerator.hasNext() && iGenericEnumerator.next() instanceof Integer) {
                return this.get_Item((TKey)index);
            }
            return (TItem)super.get_Item(index);
        }
        return (TItem)super.get_Item(index);
    }

    public TItem get_Item(TKey key) {
        if (this.fx != null) {
            return this.fx.get_Item(key);
        }
        int n = this.fx(key);
        if (n >= 0) {
            return (TItem)super.get_Item(n);
        }
        throw new KeyNotFoundException();
    }

    protected void changeItemKey(TItem item, TKey newKey) {
        if (!this.containsItem(item)) {
            throw new ArgumentException();
        }
        TKey TKey = this.getKeyForItem(item);
        if (this.jz.equalsT(TKey, newKey)) {
            return;
        }
        if (this.containsKey(newKey)) {
            throw new ArgumentException();
        }
        if (this.fx != null) {
            if (!this.fx.removeItemByKey(TKey)) {
                throw new ArgumentException();
            }
            this.fx.addItem(newKey, item);
        }
    }

    @Override
    public void clear() {
        if (this.fx != null) {
            this.fx.clear();
        }
        super.clear();
    }

    protected abstract TKey getKeyForItem(TItem var1);

    @Override
    public void insertItem(int index, TItem item) {
        int n;
        TKey TKey = this.getKeyForItem(item);
        if (TKey == null) {
            throw new ArgumentNullException("GetKeyForItem(item)");
        }
        if (this.fx != null && this.fx.containsKey(TKey)) {
            throw new ArgumentException("An element with the same key already exists in the dictionary.");
        }
        if (this.fx == null) {
            for (n = 0; n < this.size(); ++n) {
                if (!this.jz.equalsT(TKey, this.getKeyForItem(super.get_Item(n)))) continue;
                throw new ArgumentException("An element with the same key already exists in the dictionary.");
            }
        }
        super.insertItem(index, item);
        if (this.fx != null) {
            this.fx.addItem(TKey, item);
        } else if (this.ny != -1 && this.size() > this.ny) {
            this.fx = new Dictionary(this.jz);
            for (n = 0; n < this.size(); ++n) {
                Object t = super.get_Item(n);
                this.fx.addItem(this.getKeyForItem(t), t);
            }
        }
    }

    @Override
    public void removeAt(int index) {
        if (this.fx != null) {
            TKey TKey = this.getKeyForItem(super.get_Item(index));
            this.fx.removeItemByKey(TKey);
        }
        super.removeAt(index);
    }

    @Override
    public void setItem(int index, TItem item) {
        if (this.fx != null) {
            this.fx.removeItemByKey(this.getKeyForItem(super.get_Item(index)));
            this.fx.addItem(this.getKeyForItem(item), item);
        }
        super.setItem(index, item);
    }

    protected IGenericDictionary<TKey, TItem> getDictionary() {
        return this.fx;
    }
}

