/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.Generic.IGenericEqualityComparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IHashCodeProvider;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.exceptions.SerializationException;
import com.aspose.slides.internal.gy.fx;
import com.aspose.slides.internal.gy.jz;
import com.aspose.slides.internal.p6.k5;
import com.aspose.slides.internal.p6.ny;
import com.aspose.slides.internal.p6.q2;
import com.aspose.slides.internal.sn.yv;
import com.aspose.slides.internal.tx.ef;
import com.aspose.slides.internal.tx.j2;
import com.aspose.slides.internal.tx.k2;
import com.aspose.slides.internal.tx.mk;
import com.aspose.slides.ms.System.p2;
import com.aspose.slides.ms.System.q7;
import com.aspose.slides.ms.System.tt;
import com.aspose.slides.ms.System.wr;
import com.aspose.slides.ms.System.wt;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@tt
public class Hashtable
implements ICollection,
IDictionary,
IEnumerable,
j2,
com.aspose.slides.internal.tx.q2,
wt,
Map {
    private IGenericEqualityComparer fx;
    private final Object jz = new Object();
    private Bucket[] ny;
    private int wr;
    private volatile boolean y4;
    private ICollection k5;
    private float q2;
    private int rb;
    private k2 yv;
    private int j2;
    private ICollection il;
    private volatile int io;
    private static final k5 dy = new k5("LoadFactor", "HashSize", "KeyComparer", "Comparer", "HashCodeProvider", "Keys", "Values");

    public Hashtable() {
        this(0, 1.0f);
    }

    Hashtable(boolean trash) {
    }

    public Hashtable(IDictionary d) {
        this(d, 1.0f);
    }

    public Hashtable(IGenericEqualityComparer equalityComparer) {
        this(0, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity) {
        this(capacity, 1.0f);
    }

    public Hashtable(IDictionary d, IGenericEqualityComparer equalityComparer) {
        this(d, 1.0f, equalityComparer);
    }

    public Hashtable(IDictionary d, float loadFactor) {
        this(d, loadFactor, (IGenericEqualityComparer)null);
    }

    @Deprecated
    public Hashtable(IHashCodeProvider hcp, Comparator comparer) {
        this(0, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, IGenericEqualityComparer equalityComparer) {
        this(capacity, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity, float loadFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Non-negative number required");
        }
        if (loadFactor < 0.1f || loadFactor > 1.0f || Float.isNaN(loadFactor)) {
            throw new ArgumentOutOfRangeException("loadFactor", p2.fx("Load factor needs to be between {0} and {1}", 0.1, 1.0));
        }
        this.q2 = 0.72f * loadFactor;
        double d = (float)capacity / this.q2;
        if (d > 2.147483647E9) {
            throw new ArgumentException("Hashtable's capacity overflowed and went negative. Check load factor, capacity and the current size of the table");
        }
        int n = d > 11.0 ? com.aspose.slides.internal.gy.fx.fx((int)d) : 11;
        this.ny = this.jz(n);
        this.rb = (int)(this.q2 * (float)n);
        this.y4 = false;
    }

    protected Hashtable(k2 info, mk context) {
        this.yv = info;
    }

    @Deprecated
    public Hashtable(IDictionary d, IHashCodeProvider hcp, Comparator comparer) {
        this(d, 1.0f, hcp, comparer);
    }

    public Hashtable(IDictionary d, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(d != null ? d.size() : 0, loadFactor, equalityComparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(capacity, loadFactor);
        this.fx = equalityComparer;
    }

    @Deprecated
    public Hashtable(IDictionary d, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(d != null ? d.size() : 0, loadFactor, hcp, comparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, loadFactor);
        this.fx = hcp == null && comparer == null ? null : new CompatibleComparer(comparer, hcp);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.fx(key, value, true);
    }

    @Override
    public void clear() {
        if (this.wr != 0) {
            this.y4 = true;
            for (int i = 0; i < this.ny.length; ++i) {
                this.ny[i].ny = 0;
                this.ny[i].fx = null;
                this.ny[i].jz = null;
            }
            this.wr = 0;
            this.j2 = 0;
            this.wr();
            this.y4 = false;
        }
    }

    @Override
    public Object deepClone() {
        Bucket[] bucketArray = this.ny;
        Hashtable hashtable = new Hashtable(this.wr, this.fx);
        hashtable.io = this.io;
        hashtable.q2 = this.q2;
        hashtable.wr = 0;
        int n = this.ny.length;
        while (n > 0) {
            Object object = bucketArray[--n].fx;
            if (object == null || object == bucketArray) continue;
            hashtable.set_Item(object, bucketArray[n].jz);
        }
        return hashtable;
    }

    @Override
    public boolean contains(Object key) {
        return this.containsKey(key);
    }

    @Override
    public boolean containsKey(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.ny;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.fx(key, this.ny.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.ny.length);
        do {
            bucketArray[n10].fx(bucket);
            if (bucket.fx == null) {
                return false;
            }
            if ((long)(bucket.ny & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.fx, key)) {
                return true;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.ny.length);
        } while (bucket.ny < 0 && ++n < this.ny.length);
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            int n = this.ny.length;
            while (--n >= 0) {
                if (this.ny[n].fx == null || this.ny[n].fx == this.ny || this.ny[n].jz != null) continue;
                return true;
            }
        } else {
            int n = this.ny.length;
            while (--n >= 0) {
                Object object = this.ny[n].jz;
                if (object == null || !object.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    private void ny(wr wr2, int n) {
        Bucket[] bucketArray = this.ny;
        int n10 = this.ny.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].fx;
            if (object == null || object == this.ny) continue;
            DictionaryEntry dictionaryEntry = new DictionaryEntry(object, bucketArray[n10].jz);
            wr2.ny(dictionaryEntry.Clone(), n++);
        }
    }

    void fx(wr wr2, int n) {
        Bucket[] bucketArray = this.ny;
        int n10 = this.ny.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].fx;
            if (object == null || object == this.ny) continue;
            wr2.ny(object, n++);
        }
    }

    @Override
    public void copyTo(wr array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array", "Array cannot be null");
        }
        if (array.wr() != 1) {
            throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
        }
        if (array.y4() - arrayIndex < this.wr) {
            throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
        }
        this.ny(array, arrayIndex);
    }

    void jz(wr wr2, int n) {
        Bucket[] bucketArray = this.ny;
        int n10 = this.ny.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].fx;
            if (object == null || object == this.ny) continue;
            wr2.ny(bucketArray[n10].jz, n++);
        }
    }

    private void jz() {
        int n = com.aspose.slides.internal.gy.fx.fx(this.ny.length * 2);
        this.fx(n);
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new HashtableEnumerator(this, 3);
    }

    protected int getHash(Object key) {
        if (this.fx != null) {
            return this.fx.hashCode(key);
        }
        return key.hashCode();
    }

    @Override
    public void getObjectData(k2 info, mk context) {
        Object[] objectArray;
        if (info == null) {
            throw new ArgumentNullException("info");
        }
        info.fx("LoadFactor", this.q2);
        info.fx("Version", this.io);
        if (this.fx == null) {
            info.fx("Comparer", null, com.aspose.slides.internal.p6.ny.fx(Comparator.class));
            info.fx("HashCodeProvider", null, com.aspose.slides.internal.p6.ny.fx(IHashCodeProvider.class));
        } else if (this.fx instanceof CompatibleComparer) {
            objectArray = (Object[])com.aspose.slides.internal.p6.ny.fx(this.fx, CompatibleComparer.class);
            info.fx("Comparer", objectArray.fx(), com.aspose.slides.internal.p6.ny.fx(Comparator.class));
            info.fx("HashCodeProvider", objectArray.jz(), com.aspose.slides.internal.p6.ny.fx(IHashCodeProvider.class));
        } else {
            info.fx("KeyComparer", this.fx, com.aspose.slides.internal.p6.ny.fx(IGenericEqualityComparer.class));
        }
        info.fx("HashSize", this.ny.length);
        objectArray = new Object[this.wr];
        Object[] objectArray2 = new Object[this.wr];
        this.fx(com.aspose.slides.ms.System.wr.fx(objectArray), 0);
        this.jz(com.aspose.slides.ms.System.wr.fx(objectArray2), 0);
        info.fx("Keys", objectArray, com.aspose.slides.internal.p6.ny.fx(Object[].class));
        info.fx("Values", objectArray2, com.aspose.slides.internal.p6.ny.fx(Object[].class));
    }

    private long fx(Object object, int n, long[] lArray, long[] lArray2) {
        long l;
        lArray[0] = l = (long)(this.getHash(object) & Integer.MAX_VALUE);
        lArray2[0] = 1L + (((lArray[0] & 0xFFFFFFFFL) >> 5) + 1L) % (long)(n - 1);
        return l;
    }

    private void fx(Object object, Object object2, boolean bl2) {
        block12: {
            long l = 0L;
            long l10 = 0L;
            if (object == null) {
                throw new ArgumentNullException("key", "Key cannot be null");
            }
            if (this.wr >= this.rb) {
                this.jz();
            } else if (this.j2 > this.rb && this.wr > 100) {
                this.ny();
            }
            long[] lArray = new long[]{0L};
            long[] lArray2 = new long[]{0L};
            long l11 = this.fx(object, this.ny.length, lArray, lArray2);
            l = lArray[0];
            l10 = lArray2[0];
            int n = 0;
            int n10 = -1;
            int n11 = (int)((l & 0xFFFFFFFFL) % (long)this.ny.length);
            do {
                if (n10 == -1 && this.ny[n11].fx == this.ny && this.ny[n11].ny < 0) {
                    n10 = n11;
                }
                if (this.ny[n11].fx == null || this.ny[n11].fx == this.ny && ((long)this.ny[n11].ny & 0x80000000L) == 0L) {
                    if (n10 != -1) {
                        n11 = n10;
                    }
                    this.y4 = true;
                    this.ny[n11].jz = object2;
                    this.ny[n11].fx = object;
                    this.ny[n11].ny |= (int)(l11 & 0xFFFFFFFFL);
                    ++this.wr;
                    this.wr();
                    this.y4 = false;
                    break block12;
                }
                if ((long)(this.ny[n11].ny & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(this.ny[n11].fx, object)) {
                    if (bl2) {
                        throw new ArgumentException(p2.fx("Item has already been added. Key in dictionary: '{0}'  Key being added: '{1}'", this.ny[n11].fx, object));
                    }
                    this.y4 = true;
                    this.ny[n11].jz = object2;
                    this.wr();
                    this.y4 = false;
                    break block12;
                }
                if (n10 == -1 && this.ny[n11].ny >= 0) {
                    this.ny[n11].ny = (int)((long)this.ny[n11].ny | Integer.MIN_VALUE);
                    ++this.j2;
                }
                n11 = (int)(((long)n11 + (l10 & 0xFFFFFFFFL)) % (long)this.ny.length);
            } while (++n < this.ny.length);
            if (n10 == -1) {
                throw new InvalidOperationException("Hashtable insert failed. Load factor too high.");
            }
            this.y4 = true;
            this.ny[n10].jz = object2;
            this.ny[n10].fx = object;
            this.ny[n10].ny |= (int)(l11 & 0xFFFFFFFFL);
            ++this.wr;
            this.wr();
            this.y4 = false;
        }
    }

    protected boolean keyEquals(Object item, Object key) {
        if (q7.jz(this.ny, item)) {
            return false;
        }
        if (this.fx != null) {
            return this.fx.equals(item, key);
        }
        return item != null && item.equals(key);
    }

    @Override
    public void onDeserialization(Object sender) {
        if (this.ny == null) {
            if (this.yv == null) {
                throw new SerializationException("OnDeserialization method was called while the object was not being deserialized.");
            }
            int n = 0;
            Comparator comparator = null;
            IHashCodeProvider iHashCodeProvider = null;
            Object[] objectArray = null;
            Object[] objectArray2 = null;
            ef ef2 = this.yv.wr();
            while (ef2.hasNext()) {
                switch (dy.fx(ef2.jz())) {
                    case 0: {
                        this.q2 = this.yv.jz("LoadFactor");
                        break;
                    }
                    case 1: {
                        n = this.yv.fx("HashSize");
                        break;
                    }
                    case 2: {
                        this.fx = (IGenericEqualityComparer)this.yv.fx("KeyComparer", com.aspose.slides.internal.p6.ny.fx(IGenericEqualityComparer.class));
                        break;
                    }
                    case 3: {
                        comparator = (Comparator)this.yv.fx("Comparer", com.aspose.slides.internal.p6.ny.fx(Comparator.class));
                        break;
                    }
                    case 4: {
                        iHashCodeProvider = (IHashCodeProvider)this.yv.fx("HashCodeProvider", com.aspose.slides.internal.p6.ny.fx(IHashCodeProvider.class));
                        break;
                    }
                    case 5: {
                        objectArray = (Object[])this.yv.fx("Keys", com.aspose.slides.internal.p6.ny.fx(Object[].class));
                        break;
                    }
                    case 6: {
                        objectArray2 = (Object[])this.yv.fx("Values", com.aspose.slides.internal.p6.ny.fx(Object[].class));
                    }
                }
            }
            this.rb = (int)(this.q2 * (float)n);
            if (this.fx == null && (comparator != null || iHashCodeProvider != null)) {
                this.fx = new CompatibleComparer(comparator, iHashCodeProvider);
            }
            this.ny = this.jz(n);
            if (objectArray == null) {
                throw new SerializationException("The Keys for this dictionary are missing");
            }
            if (objectArray2 == null) {
                throw new SerializationException("The Values for this dictionary are missing");
            }
            if (objectArray.length != objectArray2.length) {
                throw new SerializationException("The keys and values arrays have different sizes");
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    throw new SerializationException("One of the serialized keys is null");
                }
                this.fx(objectArray[i], objectArray2[i], true);
            }
            this.io = this.yv.fx("Version");
            this.yv = null;
        }
    }

    private void fx(Bucket[] bucketArray, Object object, Object object2, int n) {
        long l = 1L + ((((long)n & 0xFFFFFFFFL) >> 5) + 1L) % (long)(bucketArray.length - 1);
        int n10 = (int)(((long)n & 0xFFFFFFFFL) % (long)bucketArray.length);
        while (true) {
            if (bucketArray[n10].fx == null || bucketArray[n10].fx == this.ny) {
                bucketArray[n10].jz = object2;
                bucketArray[n10].fx = object;
                bucketArray[n10].ny |= n;
                break;
            }
            if (bucketArray[n10].ny >= 0) {
                bucketArray[n10].ny = (int)((long)bucketArray[n10].ny | Integer.MIN_VALUE);
                ++this.j2;
            }
            n10 = (int)(((long)n10 + (l & 0xFFFFFFFFL)) % (long)bucketArray.length);
        }
    }

    private void ny() {
        this.fx(this.ny.length);
    }

    private void fx(int n) {
        this.j2 = 0;
        Bucket[] bucketArray = this.jz(n);
        for (int i = 0; i < this.ny.length; ++i) {
            Bucket bucket = this.ny[i].fx();
            if (bucket.fx == null || bucket.fx == this.ny) continue;
            this.fx(bucketArray, bucket.fx, bucket.jz, bucket.ny & Integer.MAX_VALUE);
        }
        this.y4 = true;
        this.ny = bucketArray;
        this.rb = (int)(this.q2 * (float)n);
        this.wr();
        this.y4 = false;
    }

    @Override
    public void removeItem(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.fx(key, this.ny.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.ny.length);
        do {
            this.ny[n10].fx(bucket);
            if ((long)(bucket.ny & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.fx, key)) {
                this.y4 = true;
                this.ny[n10].ny = (int)((long)this.ny[n10].ny & Integer.MIN_VALUE);
                this.ny[n10].fx = this.ny[n10].ny != 0 ? this.ny : null;
                this.ny[n10].jz = null;
                --this.wr;
                this.wr();
                this.y4 = false;
                break;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.ny.length);
        } while (bucket.ny < 0 && ++n < this.ny.length);
    }

    public static Hashtable sync(Hashtable table) {
        if (table == null) {
            throw new ArgumentNullException("table");
        }
        return new SyncHashtable(table);
    }

    KeyValuePairs[] fx() {
        KeyValuePairs[] keyValuePairsArray = new KeyValuePairs[this.wr];
        int n = 0;
        Bucket[] bucketArray = this.ny;
        int n10 = this.ny.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].fx;
            if (object == null || object == this.ny) continue;
            keyValuePairsArray[n++] = new KeyValuePairs(object, bucketArray[n10].jz);
        }
        return keyValuePairsArray;
    }

    private void wr() {
        ++this.io;
    }

    private Bucket[] jz(int n) {
        Bucket[] bucketArray = new Bucket[n];
        for (int i = 0; i < bucketArray.length; ++i) {
            bucketArray[i] = new Bucket();
        }
        return bucketArray;
    }

    @Override
    public int size() {
        return this.wr;
    }

    protected IGenericEqualityComparer getEqualityComparer() {
        return this.fx;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object get_Item(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.ny;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.fx(key, this.ny.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.ny.length);
        do {
            int n11;
            int n12 = 0;
            do {
                n11 = this.io;
                bucketArray[n10].fx(bucket);
                if (++n12 % 8 != 0) continue;
                com.aspose.slides.internal.sn.yv.jz(1);
            } while (this.y4 || n11 != this.io);
            if (bucket.fx == null) break;
            if ((long)(bucket.ny & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.fx, key)) {
                return bucket.jz;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.ny.length);
        } while (bucket.ny < 0 && ++n < this.ny.length);
        return null;
    }

    @Override
    public void set_Item(Object key, Object value) {
        this.fx(key, value, false);
    }

    @Override
    public ICollection getKeys() {
        if (this.k5 == null) {
            this.k5 = new KeyCollection(this);
        }
        return this.k5;
    }

    @Override
    public Object getSyncRoot() {
        return this.jz;
    }

    @Override
    public ICollection getValues() {
        if (this.il == null) {
            this.il = new ValueCollection(this);
        }
        return this.il;
    }

    @Override
    public boolean isEmpty() {
        return this.wr == 0;
    }

    public Object get(Object key) {
        return this.get_Item(key);
    }

    public Object put(Object key, Object value) {
        Object object = this.get_Item(key);
        this.set_Item(key, value);
        return object;
    }

    public Object remove(Object key) {
        Object object = this.get_Item(key);
        this.removeItem(key);
        return object;
    }

    public void putAll(Map m) {
        Set set = m.keySet();
        for (Object k : set) {
            Object v = m.get(k);
            this.put(k, v);
        }
    }

    public Set keySet() {
        Object[] objectArray = new Object[this.size()];
        wr wr2 = com.aspose.slides.ms.System.wr.fx(objectArray);
        this.getKeys().copyTo(wr2, 0);
        return new ReadOnlyItemCollection(wr2);
    }

    public Collection values() {
        Object[] objectArray = new Object[this.size()];
        wr wr2 = com.aspose.slides.ms.System.wr.fx(objectArray);
        this.getValues().copyTo(wr2, 0);
        return new ReadOnlyItemCollection(wr2);
    }

    public Set entrySet() {
        KeyValuePairs[] keyValuePairsArray = this.fx();
        Map.Entry[] entryArray = new Map.Entry[keyValuePairsArray.length];
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = new AbstractMap.SimpleEntry<Object, Object>(keyValuePairsArray[i].fx(), keyValuePairsArray[i].jz());
        }
        return new ReadOnlyItemCollection(com.aspose.slides.ms.System.wr.fx(entryArray));
    }

    public int getVersion() {
        return this.io;
    }

    public static Hashtable fromJava(Map map) {
        if (map == null) {
            return null;
        }
        return new jz(map);
    }

    public static Map toJava(Hashtable h) {
        return h;
    }

    private class ReadOnlyItemCollection
    implements Set {
        private wr jz;

        ReadOnlyItemCollection(wr items) {
            this.jz = items;
        }

        @Override
        public int size() {
            return this.jz.size();
        }

        @Override
        public boolean isEmpty() {
            return this.jz.size() == 0;
        }

        @Override
        public boolean contains(Object o) {
            return this.jz.contains(o);
        }

        @Override
        public Iterator iterator() {
            return this.jz.iterator();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            wr wr2 = com.aspose.slides.ms.System.wr.fx(objectArray);
            this.jz.copyTo(wr2, 0);
            return objectArray;
        }

        @Override
        public boolean add(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean remove(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean containsAll(Collection c) {
            for (Object e : c) {
                if (this.contains(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public Object[] toArray(Object[] a) {
            if (a.length <= this.size()) {
                a = new Object[this.size()];
            }
            this.jz.copyTo(com.aspose.slides.ms.System.wr.fx(a), 0);
            return a;
        }
    }

    private static class HashtableDebugView {
    }

    @tt
    private static class SyncHashtable
    extends Hashtable {
        protected Hashtable fx;

        SyncHashtable(Hashtable table) {
            super(false);
            this.fx = table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                this.fx.addItem(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                this.fx.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                return Hashtable.sync((Hashtable)this.fx.deepClone());
            }
        }

        @Override
        public boolean contains(Object key) {
            return this.fx.contains(key);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.fx.containsKey(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object key) {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                return this.fx.containsValue(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(wr array, int arrayIndex) {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                this.fx.copyTo(array, arrayIndex);
            }
        }

        @Override
        public IDictionaryEnumerator iterator() {
            return this.fx.iterator();
        }

        @Override
        public void getObjectData(k2 info, mk context) {
            if (info == null) {
                throw new ArgumentNullException("info");
            }
            info.fx("ParentTable", this.fx, com.aspose.slides.internal.p6.ny.fx(Hashtable.class));
        }

        @Override
        public void onDeserialization(Object sender) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                this.fx.removeItem(key);
            }
        }

        @Override
        KeyValuePairs[] fx() {
            return this.fx.fx();
        }

        @Override
        public int size() {
            return this.fx.size();
        }

        @Override
        public boolean isFixedSize() {
            return this.fx.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.fx.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object get_Item(Object key) {
            return this.fx.get_Item(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                this.fx.set_Item(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                return this.fx.getKeys();
            }
        }

        @Override
        public Object getSyncRoot() {
            return this.fx.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            Object object = this.fx.getSyncRoot();
            synchronized (object) {
                return this.fx.getValues();
            }
        }
    }

    @tt
    private static class ValueCollection
    implements ICollection,
    IEnumerable {
        private Hashtable fx;

        ValueCollection(Hashtable hashtable) {
            this.fx = hashtable;
        }

        @Override
        public void copyTo(wr array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.wr() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.y4() - arrayIndex < this.fx.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.fx.jz(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.fx, 2);
        }

        @Override
        public int size() {
            return this.fx.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.fx.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.fx.getSyncRoot();
        }
    }

    @tt
    private static class KeyCollection
    implements ICollection,
    IEnumerable {
        private Hashtable fx;

        KeyCollection(Hashtable hashtable) {
            this.fx = hashtable;
        }

        @Override
        public void copyTo(wr array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.wr() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.y4() - arrayIndex < this.fx.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.fx.fx(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.fx, 1);
        }

        @Override
        public int size() {
            return this.fx.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.fx.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.fx.getSyncRoot();
        }
    }

    @tt
    private static class HashtableEnumerator
    implements IDictionaryEnumerator,
    IEnumerator {
        private int fx;
        private boolean jz;
        private Object ny;
        private Object wr;
        private int y4;
        private Hashtable k5;
        private int q2;

        HashtableEnumerator(Hashtable hashtable, int getObjRetType) {
            this.k5 = hashtable;
            this.fx = hashtable.ny.length;
            this.q2 = hashtable.io;
            this.jz = false;
            this.y4 = getObjRetType;
        }

        @Override
        public boolean hasNext() {
            if (this.q2 != this.k5.io) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            while (this.fx > 0) {
                --this.fx;
                Object object = ((Hashtable)this.k5).ny[this.fx].fx;
                if (object == null || object == this.k5.ny) continue;
                this.ny = object;
                this.wr = ((Hashtable)this.k5).ny[this.fx].jz;
                this.jz = true;
                return true;
            }
            this.jz = false;
            return false;
        }

        @Override
        public void reset() {
            if (this.q2 != this.k5.io) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            this.jz = false;
            this.fx = this.k5.ny.length;
            this.ny = null;
            this.wr = null;
        }

        @Override
        public Object next() {
            if (!this.jz) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            if (this.y4 == 1) {
                return this.ny;
            }
            if (this.y4 == 2) {
                return this.wr;
            }
            return new DictionaryEntry(this.ny, this.wr);
        }

        @Override
        public DictionaryEntry getEntry() {
            if (!this.jz) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return new DictionaryEntry(this.ny, this.wr);
        }

        @Override
        public Object getKey() {
            if (!this.jz) {
                throw new InvalidOperationException("Enumeration has not started. Call HasNext");
            }
            return this.ny;
        }

        @Override
        public Object getValue() {
            if (!this.jz) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return this.wr;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static class KeyValuePairs {
        private Object fx;
        private Object jz;

        public KeyValuePairs(Object key, Object value) {
            this.jz = value;
            this.fx = key;
        }

        public Object fx() {
            return this.fx;
        }

        public Object jz() {
            return this.jz;
        }
    }

    private static class Bucket
    extends q2<Bucket> {
        public Object fx;
        public Object jz;
        public int ny;

        public void fx(Bucket bucket) {
            bucket.fx = this.fx;
            bucket.jz = this.jz;
            bucket.ny = this.ny;
        }

        public Bucket fx() {
            Bucket bucket = new Bucket();
            this.fx(bucket);
            return bucket;
        }

        public Object clone() {
            return this.fx();
        }

        private boolean jz(Bucket bucket) {
            return q7.fx(bucket.fx, this.fx) && q7.fx(bucket.jz, this.jz) && bucket.ny == this.ny;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (q7.jz(null, obj)) {
                return false;
            }
            if (q7.jz(this, obj)) {
                return true;
            }
            if (!(obj instanceof Bucket)) {
                return false;
            }
            return this.jz((Bucket)obj);
        }

        public int hashCode() {
            int n = this.fx != null ? this.fx.hashCode() : 0;
            n = 31 * n + (this.jz != null ? this.jz.hashCode() : 0);
            n = 31 * n + this.ny;
            return n;
        }

        @Override
        public /* synthetic */ Object Clone() {
            return this.fx();
        }

        @Override
        public /* synthetic */ void CloneTo(Object object) {
            this.fx((Bucket)object);
        }
    }

    @tt
    private static class CompatibleComparer
    implements IGenericEqualityComparer {
        private Comparator fx;
        private IHashCodeProvider jz;

        CompatibleComparer(Comparator comparer, IHashCodeProvider hashCodeProvider) {
            this.fx = comparer;
            this.jz = hashCodeProvider;
        }

        public int fx(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (this.fx != null) {
                return this.fx.compare(object, object2);
            }
            Comparable comparable = (Comparable)((Object)com.aspose.slides.internal.p6.ny.fx(object, Comparable.class));
            if (comparable == null) {
                throw new ArgumentException("At least one object must implement java.lang.Comparable");
            }
            return comparable.compareTo(object2);
        }

        @Override
        public boolean equals(Object x, Object y) {
            return this.equalsT(x, y);
        }

        @Override
        public int hashCode(Object obj) {
            return this.hashCodeT(obj);
        }

        public boolean equalsT(Object a, Object b) {
            return this.fx(a, b) == 0;
        }

        public int hashCodeT(Object obj) {
            if (obj == null) {
                throw new ArgumentNullException("obj");
            }
            if (this.jz != null) {
                return this.jz.hashCode(obj);
            }
            return obj.hashCode();
        }

        Comparator fx() {
            return this.fx;
        }

        IHashCodeProvider jz() {
            return this.jz;
        }
    }
}

