/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericCollection;
import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.ArrayTypeMismatchException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.p6.ny;
import com.aspose.slides.internal.p6.q2;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.a2;
import com.aspose.slides.ms.System.q7;
import com.aspose.slides.ms.System.tt;
import com.aspose.slides.ms.System.wr;
import java.util.Arrays;

@tt
public class Stack<T>
implements IGenericEnumerable<T>,
ICollection<T> {
    private Object[] fx;
    private int jz;
    private int ny;

    public Stack() {
    }

    public Stack(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.fx = new Object[capacity];
    }

    public Stack(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (Object t : collection) {
            this.push(t);
        }
    }

    public Stack(IGenericCollection<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        if (collection != null) {
            this.jz = collection.size();
            this.fx = new Object[this.jz];
            collection.copyToTArray(this.fx, 0);
        }
    }

    public void clear() {
        if (this.fx != null) {
            wr.fx(this.fx, 0, this.fx.length);
        }
        this.jz = 0;
        ++this.ny;
    }

    public boolean contains(T item) {
        return this.fx != null && wr.fx(this.fx, item, 0, this.jz) != -1;
    }

    public void copyToTArray(T[] array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (arrayIndex >= array.length) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (this.jz - arrayIndex > array.length) {
            throw new ArgumentException("idx");
        }
        if (this.fx != null) {
            wr.fx(this.fx, 0, array, arrayIndex, this.jz);
            a2.fx(array, arrayIndex, this.jz);
        }
    }

    public T peek() {
        if (this.jz == 0) {
            throw new InvalidOperationException();
        }
        return (T)this.fx[this.jz - 1];
    }

    public T pop() {
        if (this.jz == 0) {
            throw new InvalidOperationException();
        }
        ++this.ny;
        Object object = this.fx[--this.jz];
        this.fx[this.jz] = null;
        return (T)object;
    }

    public void push(T item) {
        if (this.fx == null || this.jz == this.fx.length) {
            if (this.fx == null) {
                this.fx = new Object[16];
            }
            this.fx = Arrays.copyOf(this.fx, this.jz == 0 ? 16 : 2 * this.jz);
        }
        ++this.ny;
        this.fx[this.jz++] = item;
    }

    public <T> T[] toArray(T[] array) {
        if (array.length >= this.jz) {
            this.copyTo(wr.fx(array), 0);
            return array;
        }
        wr wr2 = wr.fx(com.aspose.slides.internal.p6.ny.fx(array.getClass().getComponentType()), this.jz);
        this.copyTo(wr2, 0);
        return (Object[])wr.fx(wr2);
    }

    public void trimExcess() {
        if (this.fx != null && (double)this.jz < (double)this.fx.length * 0.9) {
            this.fx = Arrays.copyOf(this.fx, this.jz);
        }
        ++this.ny;
    }

    @Override
    public int size() {
        return this.jz;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(wr dest, int idx) {
        try {
            if (dest == null) {
                throw new ArgumentNullException();
            }
            if (this.fx != null) {
                if (idx < 0) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (idx >= this.jz) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (this.jz - idx > dest.y4()) {
                    throw new ArgumentException("idx");
                }
                wr.fx(wr.fx(this.fx), 0, dest, idx, this.jz);
                wr.jz(dest, idx, this.jz);
            }
        }
        catch (ArrayTypeMismatchException arrayTypeMismatchException) {
            throw new ArgumentException();
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @tt
    public static class Enumerator<T>
    extends q2<Enumerator>
    implements IGenericEnumerator<T>,
    IDisposable {
        private Stack<T> jz;
        private int ny;
        private int wr;

        public Enumerator() {
        }

        Enumerator(Stack<T> t) {
            this.jz = t;
            this.ny = -2;
            this.wr = ((Stack)t).ny;
        }

        @Override
        public void dispose() {
            this.ny = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.wr != ((Stack)this.jz).ny) {
                throw new IllegalStateException();
            }
            if (this.ny == -2) {
                this.ny = ((Stack)this.jz).jz;
            }
            return this.ny != -1 && --this.ny != -1;
        }

        @Override
        public T next() {
            if (this.ny < 0) {
                throw new InvalidOperationException();
            }
            return (T)((Stack)this.jz).fx[this.ny];
        }

        @Override
        public void reset() {
            if (this.wr != ((Stack)this.jz).ny) {
                throw new IllegalStateException();
            }
            this.ny = -2;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator that) {
            that.jz = this.jz;
            that.ny = this.ny;
            that.wr = this.wr;
        }

        @Override
        public Enumerator Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean fx(Enumerator enumerator) {
            return q7.fx(enumerator.jz, this.jz) && enumerator.ny == this.ny && enumerator.wr == this.wr;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (q7.jz(null, obj)) {
                return false;
            }
            if (q7.jz(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.fx((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.jz != null ? this.jz.hashCode() : 0;
            n = 31 * n + this.ny;
            n = 31 * n + this.wr;
            return n;
        }
    }
}

